/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.MalformedProtobufException;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.exception.ProtoStreamException;
import org.infinispan.protostream.impl.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void fieldReadOutOfSequence(String fieldName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.fieldReadOutOfSequence$str(), (Object)fieldName);
    }

    protected String fieldReadOutOfSequence$str() {
        return "IPROTO000001: Field %s was read out of sequence leading to sub-optimal performance";
    }

    @Override
    public final void fieldWriteOutOfSequence(String fieldName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.fieldWriteOutOfSequence$str(), (Object)fieldName);
    }

    protected String fieldWriteOutOfSequence$str() {
        return "IPROTO000002: Field %s was written out of sequence and will lead to sub-optimal read performance";
    }

    protected String messageTruncated$str() {
        return "IPROTO000003: Input data ended unexpectedly in the middle of a field. The message is corrupt.";
    }

    @Override
    public final MalformedProtobufException messageTruncated(Throwable cause) {
        MalformedProtobufException result = new MalformedProtobufException(String.format(this.getLoggingLocale(), this.messageTruncated$str(), new Object[0]), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String malformedVarint$str() {
        return "IPROTO000004: Encountered a malformed varint.";
    }

    @Override
    public final MalformedProtobufException malformedVarint() {
        MalformedProtobufException result = new MalformedProtobufException(String.format(this.getLoggingLocale(), this.malformedVarint$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String negativeLength$str() {
        return "IPROTO000005: Encountered a length delimited field with negative length.";
    }

    @Override
    public final MalformedProtobufException negativeLength() {
        MalformedProtobufException result = new MalformedProtobufException(String.format(this.getLoggingLocale(), this.negativeLength$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String globalLimitExceeded$str() {
        return "IPROTO000006: Protobuf message appears to be larger than the configured limit. The message is possibly corrupt.";
    }

    @Override
    public final MalformedProtobufException globalLimitExceeded() {
        MalformedProtobufException result = new MalformedProtobufException(String.format(this.getLoggingLocale(), this.globalLimitExceeded$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String outOfWriteBufferSpace$str() {
        return "IPROTO000007: Ran out of buffer space";
    }

    @Override
    public final IOException outOfWriteBufferSpace(Throwable cause) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.outOfWriteBufferSpace$str(), new Object[0]), cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String maxNestedMessageDepth$str() {
        return "IPROTO000008: The nested message depth appears to be larger than the configured limit of '%s'.It is possible that the entity to marshall with type '%s' can have some circular dependencies.";
    }

    @Override
    public final ProtoStreamException maxNestedMessageDepth(int maxNestedMessageDepth, Class<?> entityType) {
        ProtoStreamException result = new ProtoStreamException(String.format(this.getLoggingLocale(), this.maxNestedMessageDepth$str(), maxNestedMessageDepth, entityType));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notRepeatableField$str() {
        return "IPROTO000009: Not a repeatable field: %s#%s";
    }

    @Override
    public final IllegalStateException notRepeatableField(String clazz, String fieldOrMethod) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notRepeatableField$str(), clazz, fieldOrMethod));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String reservedName$str() {
        return "IPROTO000010: Name '%s' is reserved on `%s`";
    }

    @Override
    public final IllegalArgumentException reservedName(String name, String owner) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.reservedName$str(), name, owner));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String reservedNumber$str() {
        return "IPROTO000011: Number %d used by '%s' is reserved on '%s'";
    }

    @Override
    public final IllegalArgumentException reservedNumber(int number, String name, String owner) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.reservedNumber$str(), number, name, owner));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedSyntax$str() {
        return "IPROTO000012: Unsupported protocol buffers syntax '%s'";
    }

    @Override
    public final IllegalArgumentException unsupportedSyntax(FileDescriptor.Syntax s) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedSyntax$str(), new Object[]{s}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String parserException$str() {
        return "IPROTO000013: Error while parsing '%s': %s";
    }

    @Override
    public final DescriptorParserException parserException(String filename, String message) {
        DescriptorParserException result = new DescriptorParserException(String.format(this.getLoggingLocale(), this.parserException$str(), filename, message));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String abstractType$str() {
        return "IPROTO000014: The type %s of field %s of %s should not be abstract.";
    }

    @Override
    public final ProtoSchemaBuilderException abstractType(String canonicalName, String fieldName, String canonicalName1) {
        ProtoSchemaBuilderException result = new ProtoSchemaBuilderException(String.format(this.getLoggingLocale(), this.abstractType$str(), canonicalName, fieldName, canonicalName1));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String oneofCollision$str() {
        return "IPROTO000015: The field named '%s' of %s is a member of the '%s' oneof which collides with an existing field or oneof.";
    }

    @Override
    public final ProtoSchemaBuilderException oneofCollision(String fieldName, String name, String oneof) {
        ProtoSchemaBuilderException result = new ProtoSchemaBuilderException(String.format(this.getLoggingLocale(), this.oneofCollision$str(), fieldName, name, oneof));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String oneofRepeatedOrRequired$str() {
        return "IPROTO000016: The field named '%s' of %s cannot be marked repeated or required since it is member of the '%s' oneof.";
    }

    @Override
    public final ProtoSchemaBuilderException oneofRepeatedOrRequired(String fieldName, String name, String oneof) {
        ProtoSchemaBuilderException result = new ProtoSchemaBuilderException(String.format(this.getLoggingLocale(), this.oneofRepeatedOrRequired$str(), fieldName, name, oneof));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String abstractClassNotAllowed$str() {
        return "IPROTO000017: Abstract classes are not allowed: '%s'";
    }

    @Override
    public final ProtoSchemaBuilderException abstractClassNotAllowed(String annotatedClassName) {
        ProtoSchemaBuilderException result = new ProtoSchemaBuilderException(String.format(this.getLoggingLocale(), this.abstractClassNotAllowed$str(), annotatedClassName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String localOrAnonymousClass$str() {
        return "IPROTO000018: Local or anonymous classes are not allowed. The class '%s' must be instantiable using an accessible no-argument constructor.";
    }

    @Override
    public final ProtoSchemaBuilderException localOrAnonymousClass(String annotatedClassName) {
        ProtoSchemaBuilderException result = new ProtoSchemaBuilderException(String.format(this.getLoggingLocale(), this.localOrAnonymousClass$str(), annotatedClassName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonStaticInnerClass$str() {
        return "IPROTO000019: Non-static inner classes are not allowed. The class '%s' must be instantiable using an accessible no-argument constructor.";
    }

    @Override
    public final ProtoSchemaBuilderException nonStaticInnerClass(String annotatedClassName) {
        ProtoSchemaBuilderException result = new ProtoSchemaBuilderException(String.format(this.getLoggingLocale(), this.nonStaticInnerClass$str(), annotatedClassName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDefaultEnum$str() {
        return "IPROTO000020: Invalid default value for field '%s' of Java type %s from class %s: the %s enum must have a 0 value";
    }

    @Override
    public final ProtoSchemaBuilderException noDefaultEnum(String fieldName, String canonicalName, String canonicalName1, String fullName) {
        ProtoSchemaBuilderException result = new ProtoSchemaBuilderException(String.format(this.getLoggingLocale(), this.noDefaultEnum$str(), fieldName, canonicalName, canonicalName1, fullName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

