/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.schema;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.protostream.schema.CommentContainer;
import org.infinispan.protostream.schema.EnumContainer;
import org.infinispan.protostream.schema.EnumValue;
import org.infinispan.protostream.schema.Message;
import org.infinispan.protostream.schema.OptionContainer;
import org.infinispan.protostream.schema.ReservedContainer;
import org.infinispan.protostream.schema.Schema;

public class Enum {
    private final String name;
    private final String fullName;
    private final Map<String, Object> options;
    private final List<String> comments;
    private final Map<String, EnumValue> values;
    private final BitSet reservedNumbers;
    private final Set<String> reservedNames;

    private Enum(Builder builder) {
        this.name = builder.name;
        this.fullName = builder.getFullName();
        this.values = builder.values.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((EnumValue.Builder)e.getValue()).create()));
        this.reservedNumbers = builder.reservedNumbers;
        this.reservedNames = Set.copyOf(builder.reservedNames);
        this.options = Map.copyOf(builder.options);
        this.comments = List.copyOf(builder.comments);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Map<String, EnumValue> getValues() {
        return this.values;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public BitSet getReservedNumbers() {
        return this.reservedNumbers;
    }

    public Set<String> getReservedNames() {
        return this.reservedNames;
    }

    public static class Builder
    implements CommentContainer<Builder>,
    ReservedContainer<Builder>,
    OptionContainer<Builder> {
        private final EnumContainer parent;
        private final String name;
        private final Map<String, EnumValue.Builder> values = new HashMap<String, EnumValue.Builder>();
        private final BitSet reservedNumbers = new BitSet();
        private final Set<String> reservedNames = new HashSet<String>();
        private final Map<String, Object> options = new HashMap<String, Object>();
        private final List<String> comments = new ArrayList<String>();

        Builder(EnumContainer parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public EnumValue.Builder addValue(String name, int number) {
            Objects.requireNonNull(name, "name must not be null");
            this.checkDuplicate(name);
            EnumValue.Builder value = new EnumValue.Builder(this, name, number);
            this.values.put(name, value);
            return value;
        }

        private void checkDuplicate(String name) {
            if (this.values.containsKey(name) || this.reservedNames.contains(name)) {
                throw new IllegalArgumentException("Duplicate name " + name);
            }
        }

        @Override
        public Builder addReserved(int ... numbers) {
            for (int number : numbers) {
                this.reservedNumbers.set(number);
            }
            return this;
        }

        @Override
        public Builder addReservedRange(int from, int to) {
            this.reservedNumbers.set(from, to + 1);
            return this;
        }

        @Override
        public Builder addReserved(String name) {
            Objects.requireNonNull(name, "name must not be null");
            this.reservedNames.add(name);
            return this;
        }

        @Override
        public Builder addOption(String name, Object value) {
            Objects.requireNonNull(name, "name must not be null");
            Objects.requireNonNull(value, "value must not be null");
            this.options.put(name, value);
            return this;
        }

        @Override
        public Builder addComment(String comment) {
            Objects.requireNonNull(comment, "comment must not be null");
            this.comments.add(comment.trim());
            return this;
        }

        public Message.Builder addMessage(String name) {
            return this.parent.addMessage(name);
        }

        public Builder addEnum(String name) {
            return this.parent.addEnum(name);
        }

        Enum create() {
            return new Enum(this);
        }

        @Override
        public Schema build() {
            return this.parent.build();
        }

        @Override
        public String getFullName() {
            return this.parent.getFullName() + "." + this.name;
        }
    }
}

