/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.infinispan.protostream.schema.CommentContainer;
import org.infinispan.protostream.schema.Enum;
import org.infinispan.protostream.schema.FieldContainer;
import org.infinispan.protostream.schema.Map;
import org.infinispan.protostream.schema.Message;
import org.infinispan.protostream.schema.OneOf;
import org.infinispan.protostream.schema.OptionContainer;
import org.infinispan.protostream.schema.Schema;
import org.infinispan.protostream.schema.Type;

public class Field {
    protected final Type type;
    protected final String name;
    protected final String fullName;
    protected final int number;
    protected final boolean repeated;
    protected final List<String> comments;
    protected final Map<String, Object> options;

    Field(Builder builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.fullName = builder.getFullName();
        this.number = builder.number;
        this.repeated = builder.repeated;
        this.options = Map.copyOf(builder.options);
        this.comments = List.copyOf(builder.comments);
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isRepeated() {
        return this.repeated;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public static class Builder
    implements OptionContainer<Builder>,
    CommentContainer<Builder>,
    FieldContainer {
        protected final FieldContainer parent;
        protected final Type type;
        protected final String name;
        protected final int number;
        protected final boolean repeated;
        protected final List<String> comments = new ArrayList<String>();
        protected final Map<String, Object> options = new HashMap<String, Object>();

        Builder(FieldContainer parent, Type type, String name, int number, boolean repeated) {
            this.parent = parent;
            this.type = type;
            this.name = name;
            this.number = number;
            this.repeated = repeated;
        }

        @Override
        public Message.Builder addMessage(String name) {
            return this.parent.addMessage(name);
        }

        @Override
        public Builder addField(Type type, String name, int number) {
            return this.parent.addField(type, name, number);
        }

        @Override
        public Map.Builder addMap(Type.Scalar keyType, Type valueType, String name, int number) {
            return this.parent.addMap(keyType, valueType, name, number);
        }

        @Override
        public Builder addRepeatedField(Type type, String name, int number) {
            return this.parent.addRepeatedField(type, name, number);
        }

        @Override
        public Message.Builder addNestedMessage(String name, Consumer<Message.Builder> nested) {
            return this.parent.addNestedMessage(name, nested);
        }

        @Override
        public Message.Builder addNestedEnum(String name, Consumer<Enum.Builder> nested) {
            return this.parent.addNestedEnum(name, nested);
        }

        @Override
        public Enum.Builder addEnum(String name) {
            return this.parent.addEnum(name);
        }

        @Override
        public Message.Builder addOneOf(String name, Consumer<OneOf.Builder> oneof) {
            return this.parent.addOneOf(name, oneof);
        }

        @Override
        public Builder addOption(String name, Object value) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(value);
            this.options.put(name, value);
            return this;
        }

        @Override
        public Builder addComment(String comment) {
            Objects.requireNonNull(comment);
            this.comments.add(comment.trim());
            return this;
        }

        protected Field create() {
            return new Field(this);
        }

        @Override
        public Schema build() {
            return this.parent.build();
        }

        @Override
        public String getFullName() {
            return this.parent.getFullName() + "." + this.name;
        }
    }
}

