/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.infinitest.toolkit.EqualsHashCodeTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class StrictEqualsHashCodeTestSupport
extends EqualsHashCodeTestSupport {
    private Object equalButDifferentClass;

    protected abstract Object equalButDifferentClass() throws Exception;

    @Before
    public void initializeStrictHarness() throws Exception {
        this.equalButDifferentClass = this.equalButDifferentClass();
        Assert.assertNotNull((String)"equalButDifferentClass() returned null", (Object)this.equalButDifferentClass);
        StrictEqualsHashCodeTestSupport.assertNotEquals("1st equal and equal-but-different-class instances of same classes", this.firstEqual.getClass(), this.equalButDifferentClass.getClass());
        StrictEqualsHashCodeTestSupport.assertNotEquals("2nd equal and equal-but-different-class instances of same classes", this.secondEqual.getClass(), this.equalButDifferentClass.getClass());
        StrictEqualsHashCodeTestSupport.assertNotEquals("3rd equal and equal-but-different-class instances of same classes", this.thirdEqual.getClass(), this.equalButDifferentClass.getClass());
        StrictEqualsHashCodeTestSupport.assertNotEquals("not-equal and equal-but-different-class instances of same classes", this.notEqual.getClass(), this.equalButDifferentClass.getClass());
        Assert.assertThat((String)"equal-but-different-class not subclass of 1st equal class", (Object)this.equalButDifferentClass, (Matcher)CoreMatchers.instanceOf(this.firstEqual.getClass()));
        Assert.assertThat((String)"equal-but-different-class not subclass of 2nd equal class", (Object)this.equalButDifferentClass, (Matcher)CoreMatchers.instanceOf(this.secondEqual.getClass()));
        Assert.assertThat((String)"equal-but-different-class not subclass of 3rd equal class", (Object)this.equalButDifferentClass, (Matcher)CoreMatchers.instanceOf(this.thirdEqual.getClass()));
        Assert.assertThat((String)"equal-but-different-class not subclass of not-equal class", (Object)this.equalButDifferentClass, (Matcher)CoreMatchers.instanceOf(this.notEqual.getClass()));
    }

    @Test
    public void subclassInstanceWithSameValuesShouldNotCompareEqualToSuperclassInstance() {
        StrictEqualsHashCodeTestSupport.assertNotEquals("1st vs. equal-but-different-class", this.firstEqual, this.equalButDifferentClass);
        StrictEqualsHashCodeTestSupport.assertNotEquals("2nd vs. equal-but-different-class", this.secondEqual, this.equalButDifferentClass);
        StrictEqualsHashCodeTestSupport.assertNotEquals("3rd vs. equal-but-different-class", this.thirdEqual, this.equalButDifferentClass);
        StrictEqualsHashCodeTestSupport.assertNotEquals("equal-but-different-class vs. 1st", this.equalButDifferentClass, this.firstEqual);
        StrictEqualsHashCodeTestSupport.assertNotEquals("equal-but-different-class vs. 2nd", this.equalButDifferentClass, this.secondEqual);
        StrictEqualsHashCodeTestSupport.assertNotEquals("equal-but-different-class vs. 3rd", this.equalButDifferentClass, this.thirdEqual);
    }
}

