/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit.internal.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinitest.toolkit.internal.reflection.ClassUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodFinder<T> {
    private final Class<T> clazz;
    private final Map<String, List<Method>> methodsByName = new HashMap<String, List<Method>>();
    private final List<Constructor<T>> ctors = new ArrayList<Constructor<T>>();
    private final Map<Member, Class<?>[]> memberParameters = new HashMap<Member, Class<?>[]>();

    public static <U> MethodFinder<U> methodFinderFor(Class<U> clazz) {
        return new MethodFinder<U>(clazz);
    }

    private MethodFinder(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null Class parameter");
        }
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("primitive Class parameter");
        }
        if (clazz.isArray()) {
            throw new IllegalArgumentException("array Class parameter");
        }
        this.clazz = clazz;
        this.loadMethods();
        this.loadConstructors();
    }

    public Constructor<T> findConstructor(Class<?>[] parameterTypes) throws NoSuchMethodException {
        Class<?>[] types = parameterTypes;
        if (types == null) {
            types = new Class[]{};
        }
        return this.findMemberIn(this.ctors, types);
    }

    public Method findMethod(String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        List<Method> methods = this.methodsByName.get(methodName);
        if (methods == null) {
            throw new NoSuchMethodException("no method named " + this.clazz.getName() + '.' + methodName);
        }
        Class<?>[] types = parameterTypes;
        if (types == null) {
            types = new Class[]{};
        }
        return this.findMemberIn(methods, types);
    }

    public Class<?>[] getParameterTypesFrom(Object[] args) {
        Class[] argTypes = null;
        if (args != null) {
            argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i] == null ? Void.TYPE : args[i].getClass();
            }
        } else {
            argTypes = new Class[]{};
        }
        return argTypes;
    }

    public Class<?>[] getParameterTypesFrom(String[] names) throws ClassNotFoundException {
        return this.getParameterTypesFrom(names, this.getClass().getClassLoader());
    }

    public Class<?>[] getParameterTypesFrom(String[] names, ClassLoader loader) throws ClassNotFoundException {
        Class[] types;
        if (names != null) {
            types = new Class[names.length];
            for (int i = 0; i < names.length; ++i) {
                types[i] = ClassUtilities.classForNameOrPrimitive(names[i], loader);
            }
        } else {
            types = new Class[]{};
        }
        return types;
    }

    private <M extends Member> M findMemberIn(List<M> candidates, Class<?>[] parameterTypes) throws NoSuchMethodException {
        ArrayList<Member> matches = new ArrayList<Member>();
        for (Member each : candidates) {
            Object[] methodParamTypes = this.memberParameters.get(each);
            if (Arrays.equals(methodParamTypes, parameterTypes)) {
                return (M)each;
            }
            if (!ClassUtilities.compatibleClasses(methodParamTypes, parameterTypes)) continue;
            matches.add(each);
        }
        if (matches.isEmpty()) {
            throw new NoSuchMethodException("no member in " + this.clazz + " matching given args");
        }
        return (M)(matches.size() == 1 ? (Member)matches.get(0) : this.findMostSpecificMemberIn(matches));
    }

    private <M extends Member> M findMostSpecificMemberIn(List<M> candidates) throws NoSuchMethodException {
        ArrayList<Member> mostSpecificMembers = new ArrayList<Member>();
        for (Member member : candidates) {
            if (mostSpecificMembers.isEmpty()) {
                mostSpecificMembers.add(member);
                continue;
            }
            boolean moreSpecific = true;
            boolean lessSpecific = false;
            for (Member moreSpecificMember : mostSpecificMembers) {
                if (this.memberIsMoreSpecific(member, moreSpecificMember)) continue;
                moreSpecific = false;
                lessSpecific = this.memberIsMoreSpecific(moreSpecificMember, member);
                break;
            }
            if (moreSpecific) {
                mostSpecificMembers.clear();
                mostSpecificMembers.add(member);
                continue;
            }
            if (lessSpecific) continue;
            mostSpecificMembers.add(member);
        }
        if (mostSpecificMembers.size() > 1) {
            throw new NoSuchMethodException("Ambiguous request for member in " + this.clazz.getName() + " matching given args");
        }
        return (M)((Member)mostSpecificMembers.get(0));
    }

    private void loadConstructors() {
        for (Constructor<?> each : this.clazz.getDeclaredConstructors()) {
            this.ctors.add(each);
            this.memberParameters.put(each, each.getParameterTypes());
        }
    }

    private void loadMethods() {
        for (Method each : this.clazz.getMethods()) {
            String methodName = each.getName();
            Class<?>[] paramTypes = each.getParameterTypes();
            List<Method> namedMethods = this.methodsByName.get(methodName);
            if (namedMethods == null) {
                namedMethods = new ArrayList<Method>();
                this.methodsByName.put(methodName, namedMethods);
            }
            if (!ClassUtilities.classIsAccessible(this.clazz)) {
                each = ClassUtilities.getAccessibleMethodFrom(this.clazz, methodName, paramTypes);
            }
            if (each == null) continue;
            namedMethods.add(each);
            this.memberParameters.put(each, paramTypes);
        }
    }

    private boolean memberIsMoreSpecific(Member first, Member second) {
        Class<?>[] firstParamTypes = this.memberParameters.get(first);
        Class<?>[] secondParamTypes = this.memberParameters.get(second);
        return ClassUtilities.compatibleClasses(secondParamTypes, firstParamTypes);
    }
}

