/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.junit.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.instancio.exception.InstancioException;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    static List<Field> getAnnotatedFields(Class<?> klass, Class<? extends Annotation> annotation) {
        return Arrays.stream(klass.getDeclaredFields()).filter(field -> field.getAnnotation(annotation) != null).collect(Collectors.toList());
    }

    static Object getFieldValue(Field field, Object target) {
        try {
            field.setAccessible(true);
            return field.get(target);
        }
        catch (Exception ex) {
            throw new InstancioException("Unable to get value from: " + field, (Throwable)ex);
        }
    }
}

