/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.StringUtils;
import org.jacoco.core.runtime.AgentOptions;
import org.jacoco.maven.AbstractJacocoMojo;

public abstract class AbstractAgentMojo
extends AbstractJacocoMojo {
    protected static final String AGENT_ARTIFACT_NAME = "org.jacoco:org.jacoco.agent";
    protected static final String TYCHO_ARG_LINE = "tycho.testArgLine";
    protected static final String SUREFIRE_ARG_LINE = "argLine";
    protected Map<String, Artifact> pluginArtifactMap;
    protected String propertyName;
    protected Boolean append;
    protected String exclClassLoaders;
    protected String sessionId;
    protected Boolean dumpOnExit;
    protected String output;
    protected String address;
    protected Integer port;
    protected File classDumpDir;
    protected Boolean jmx;

    public void executeMojo() {
        String name = this.getEffectivePropertyName();
        Properties projectProperties = this.getProject().getProperties();
        String oldValue = projectProperties.getProperty(name);
        String newValue = this.createAgentOptions().prependVMArguments(oldValue, this.getAgentJarFile());
        this.getLog().info((CharSequence)(name + " set to " + newValue));
        projectProperties.setProperty(name, newValue);
    }

    protected File getAgentJarFile() {
        Artifact jacocoAgentArtifact = this.pluginArtifactMap.get(AGENT_ARTIFACT_NAME);
        return jacocoAgentArtifact.getFile();
    }

    protected AgentOptions createAgentOptions() {
        AgentOptions agentOptions = new AgentOptions();
        agentOptions.setDestfile(this.getDestFile().getAbsolutePath());
        if (this.append != null) {
            agentOptions.setAppend(this.append.booleanValue());
        }
        if (this.getIncludes() != null && !this.getIncludes().isEmpty()) {
            String agentIncludes = StringUtils.join(this.getIncludes().iterator(), (String)":");
            agentOptions.setIncludes(agentIncludes);
        }
        if (this.getExcludes() != null && !this.getExcludes().isEmpty()) {
            String agentExcludes = StringUtils.join(this.getExcludes().iterator(), (String)":");
            agentOptions.setExcludes(agentExcludes);
        }
        if (this.exclClassLoaders != null) {
            agentOptions.setExclClassloader(this.exclClassLoaders);
        }
        if (this.sessionId != null) {
            agentOptions.setSessionId(this.sessionId);
        }
        if (this.dumpOnExit != null) {
            agentOptions.setDumpOnExit(this.dumpOnExit.booleanValue());
        }
        if (this.output != null) {
            agentOptions.setOutput(this.output);
        }
        if (this.address != null) {
            agentOptions.setAddress(this.address);
        }
        if (this.port != null) {
            agentOptions.setPort(this.port.intValue());
        }
        if (this.classDumpDir != null) {
            agentOptions.setClassDumpDir(this.classDumpDir.getAbsolutePath());
        }
        if (this.jmx != null) {
            agentOptions.setJmx(this.jmx.booleanValue());
        }
        return agentOptions;
    }

    protected String getEffectivePropertyName() {
        if (this.isPropertyNameSpecified()) {
            return this.propertyName;
        }
        if (this.isEclipseTestPluginPackaging()) {
            return TYCHO_ARG_LINE;
        }
        return SUREFIRE_ARG_LINE;
    }

    protected boolean isPropertyNameSpecified() {
        return this.propertyName != null && !"".equals(this.propertyName);
    }

    protected boolean isEclipseTestPluginPackaging() {
        return "eclipse-test-plugin".equals(this.getProject().getPackaging());
    }

    protected abstract File getDestFile();
}

