/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_yczshm.controller;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.jacoco.agent.rt_yczshm.core.runtime.IRemoteCommandVisitor;
import org.jacoco.agent.rt_yczshm.core.runtime.IRuntime;
import org.jacoco.agent.rt_yczshm.core.runtime.RemoteControlReader;
import org.jacoco.agent.rt_yczshm.core.runtime.RemoteControlWriter;

class TcpConnection
implements IRemoteCommandVisitor {
    private final IRuntime runtime;
    private final Socket socket;
    private RemoteControlWriter writer;
    private RemoteControlReader reader;
    private boolean initialized;

    public TcpConnection(Socket socket, IRuntime runtime) {
        this.socket = socket;
        this.runtime = runtime;
        this.initialized = false;
    }

    public void init() throws IOException {
        this.writer = new RemoteControlWriter(this.socket.getOutputStream());
        this.reader = new RemoteControlReader(this.socket.getInputStream());
        this.reader.setRemoteCommandVisitor(this);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        try {
            while (this.reader.read()) {
            }
        }
        catch (SocketException e) {
            if (!this.socket.isClosed()) {
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    public void writeExecutionData() throws IOException {
        if (this.initialized && !this.socket.isClosed()) {
            this.visitDumpCommand(true, false);
        }
    }

    public void close() throws IOException {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public void visitDumpCommand(boolean dump, boolean reset) throws IOException {
        if (dump) {
            this.runtime.collect(this.writer, this.writer, reset);
        } else if (reset) {
            this.runtime.reset();
        }
        this.writer.sendCmdOk();
    }
}

