/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_yczshm.core.internal.flow;

import org.jacoco.agent.rt_yczshm.asm.ClassAdapter;
import org.jacoco.agent.rt_yczshm.asm.Label;
import org.jacoco.agent.rt_yczshm.asm.MethodVisitor;
import org.jacoco.agent.rt_yczshm.asm.commons.EmptyVisitor;
import org.jacoco.agent.rt_yczshm.asm.commons.JSRInlinerAdapter;
import org.jacoco.agent.rt_yczshm.core.internal.flow.IClassProbesVisitor;
import org.jacoco.agent.rt_yczshm.core.internal.flow.IMethodProbesVisitor;
import org.jacoco.agent.rt_yczshm.core.internal.flow.IProbeIdGenerator;
import org.jacoco.agent.rt_yczshm.core.internal.flow.LabelFlowAnalyzer;
import org.jacoco.agent.rt_yczshm.core.internal.flow.MethodProbesAdapter;

public class ClassProbesAdapter
extends ClassAdapter
implements IProbeIdGenerator {
    private static final IMethodProbesVisitor EMPTY_METHOD_PROBES_VISITOR;
    private final IClassProbesVisitor cv;
    private int counter = 0;
    private boolean interfaceType;

    static {
        class Impl
        extends EmptyVisitor
        implements IMethodProbesVisitor {
            Impl() {
            }

            public void visitProbe(int probeId) {
            }

            public void visitJumpInsnWithProbe(int opcode, Label label, int probeId) {
            }

            public void visitInsnWithProbe(int opcode, int probeId) {
            }

            public void visitTableSwitchInsnWithProbes(int min, int max, Label dflt, Label[] labels) {
            }

            public void visitLookupSwitchInsnWithProbes(Label dflt, int[] keys, Label[] labels) {
            }
        }
        EMPTY_METHOD_PROBES_VISITOR = new Impl();
    }

    public ClassProbesAdapter(IClassProbesVisitor cv) {
        super(cv);
        this.cv = cv;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.interfaceType = (access & 0x200) != 0;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public final MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        IMethodProbesVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        final IMethodProbesVisitor methodProbes = mv == null ? EMPTY_METHOD_PROBES_VISITOR : mv;
        return new JSRInlinerAdapter(null, access, name, desc, signature, exceptions){

            public void visitEnd() {
                super.visitEnd();
                this.accept(new LabelFlowAnalyzer());
                if (ClassProbesAdapter.this.interfaceType) {
                    ProbeCounter probeCounter = new ProbeCounter();
                    this.accept(new MethodProbesAdapter(EMPTY_METHOD_PROBES_VISITOR, probeCounter));
                    ClassProbesAdapter.this.cv.visitTotalProbeCount(probeCounter.count);
                }
                this.accept(new MethodProbesAdapter(methodProbes, ClassProbesAdapter.this));
            }
        };
    }

    public void visitEnd() {
        if (!this.interfaceType) {
            this.cv.visitTotalProbeCount(this.counter);
        }
        super.visitEnd();
    }

    public int nextId() {
        return this.counter++;
    }

    private static class ProbeCounter
    implements IProbeIdGenerator {
        int count = 0;

        private ProbeCounter() {
        }

        public int nextId() {
            return this.count++;
        }
    }
}

