/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_yczshm.core.internal.instr;

import java.util.ArrayList;
import java.util.Collection;
import org.jacoco.agent.rt_yczshm.asm.Label;
import org.jacoco.agent.rt_yczshm.asm.MethodVisitor;
import org.jacoco.agent.rt_yczshm.core.internal.flow.IMethodProbesVisitor;
import org.jacoco.agent.rt_yczshm.core.internal.flow.LabelInfo;
import org.jacoco.agent.rt_yczshm.core.internal.instr.IProbeArrayStrategy;
import org.jacoco.agent.rt_yczshm.core.internal.instr.InstrSupport;
import org.jacoco.agent.rt_yczshm.core.internal.instr.JumpProbe;
import org.jacoco.agent.rt_yczshm.core.internal.instr.ProbeVariableInserter;

class MethodInstrumenter
extends ProbeVariableInserter
implements IMethodProbesVisitor {
    private final IProbeArrayStrategy probeArrayStrategy;
    private int accessorStackSize;
    private Collection<JumpProbe> jumpProbes;

    public MethodInstrumenter(MethodVisitor mv, int access, String desc, IProbeArrayStrategy probeArrayStrategy) {
        super(access, desc, mv);
        this.probeArrayStrategy = probeArrayStrategy;
        this.jumpProbes = null;
    }

    public void visitCode() {
        super.visitCode();
        this.accessorStackSize = this.probeArrayStrategy.pushInstance(this.mv);
        this.mv.visitVarInsn(58, this.variable);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.insertJumpProbes();
        int increasedStack = Math.max(maxStack + 3, this.accessorStackSize);
        super.visitMaxs(increasedStack, maxLocals);
    }

    private void insertProbe(int id) {
        this.mv.visitVarInsn(25, this.variable);
        InstrSupport.push(this.mv, id);
        this.mv.visitInsn(4);
        this.visitInsn(84);
    }

    public void visitProbe(int probeId) {
        this.insertProbe(probeId);
    }

    public void visitInsnWithProbe(int opcode, int probeId) {
        this.insertProbe(probeId);
        this.mv.visitInsn(opcode);
    }

    public void visitJumpInsnWithProbe(int opcode, Label label, int probeId) {
        if (opcode == 167) {
            this.insertProbe(probeId);
            this.mv.visitJumpInsn(167, label);
        } else {
            JumpProbe probe = new JumpProbe(label, probeId);
            this.addJumpProbe(probe);
            this.mv.visitJumpInsn(opcode, probe.getIntermediate());
        }
    }

    public void visitTableSwitchInsnWithProbes(int min, int max, Label dflt, Label[] labels) {
        LabelInfo.resetDone(dflt);
        LabelInfo.resetDone(labels);
        Label newDflt = this.createIntermediate(dflt);
        Label[] newLabels = this.createIntermediates(labels);
        this.mv.visitTableSwitchInsn(min, max, newDflt, newLabels);
    }

    public void visitLookupSwitchInsnWithProbes(Label dflt, int[] keys, Label[] labels) {
        LabelInfo.resetDone(dflt);
        LabelInfo.resetDone(labels);
        Label newDflt = this.createIntermediate(dflt);
        Label[] newLabels = this.createIntermediates(labels);
        this.mv.visitLookupSwitchInsn(newDflt, keys, newLabels);
    }

    private Label[] createIntermediates(Label[] labels) {
        Label[] intermediates = new Label[labels.length];
        int i = 0;
        while (i < labels.length) {
            intermediates[i] = this.createIntermediate(labels[i]);
            ++i;
        }
        return intermediates;
    }

    private Label createIntermediate(Label label) {
        Label intermediate;
        if (LabelInfo.getProbeId(label) == -1) {
            intermediate = label;
        } else if (LabelInfo.isDone(label)) {
            intermediate = LabelInfo.getIntermediateLabel(label);
        } else {
            JumpProbe probe = new JumpProbe(label);
            this.addJumpProbe(probe);
            intermediate = probe.getIntermediate();
            LabelInfo.setDone(label);
        }
        return intermediate;
    }

    private void addJumpProbe(JumpProbe probe) {
        if (this.jumpProbes == null) {
            this.jumpProbes = new ArrayList<JumpProbe>();
        }
        this.jumpProbes.add(probe);
    }

    private void insertJumpProbes() {
        if (this.jumpProbes != null) {
            for (JumpProbe probe : this.jumpProbes) {
                this.insertJumpProbe(probe);
            }
        }
    }

    private void insertJumpProbe(JumpProbe probe) {
        this.mv.visitLabel(probe.getIntermediate());
        this.insertProbeFrame(probe.getTarget());
        this.visitProbe(probe.getProbeId());
        this.mv.visitJumpInsn(167, probe.getTarget());
    }
}

