/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_yczshm.core.runtime;

import java.util.Random;
import org.jacoco.agent.rt_yczshm.core.data.ExecutionDataStore;
import org.jacoco.agent.rt_yczshm.core.data.IExecutionDataVisitor;
import org.jacoco.agent.rt_yczshm.core.data.ISessionInfoVisitor;
import org.jacoco.agent.rt_yczshm.core.data.SessionInfo;
import org.jacoco.agent.rt_yczshm.core.runtime.ExecutionDataAccess;
import org.jacoco.agent.rt_yczshm.core.runtime.IRuntime;

public abstract class AbstractRuntime
implements IRuntime {
    protected final ExecutionDataStore store = new ExecutionDataStore();
    protected final ExecutionDataAccess access = new ExecutionDataAccess(this.store);
    private long startTimeStamp;
    private String sessionId = AbstractRuntime.createRandomId();
    private static final Random RANDOM = new Random();

    protected AbstractRuntime() {
    }

    protected final void setStartTimeStamp() {
        this.startTimeStamp = System.currentTimeMillis();
    }

    public void setSessionId(String id) {
        this.sessionId = id;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void collect(IExecutionDataVisitor executionDataVisitor, ISessionInfoVisitor sessionInfoVisitor, boolean reset) {
        ExecutionDataStore executionDataStore = this.store;
        synchronized (executionDataStore) {
            if (sessionInfoVisitor != null) {
                SessionInfo info = new SessionInfo(this.sessionId, this.startTimeStamp, System.currentTimeMillis());
                sessionInfoVisitor.visitSessionInfo(info);
            }
            this.store.accept(executionDataVisitor);
            if (reset) {
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        ExecutionDataStore executionDataStore = this.store;
        synchronized (executionDataStore) {
            this.store.reset();
            this.setStartTimeStamp();
        }
    }

    public static String createRandomId() {
        return Integer.toHexString(RANDOM.nextInt());
    }
}

