/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_6qyg3i.core.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jacoco.agent.rt_6qyg3i.core.data.ExecutionData;
import org.jacoco.agent.rt_6qyg3i.core.data.IExecutionDataVisitor;
import org.jacoco.agent.rt_6qyg3i.core.data.ISessionInfoVisitor;
import org.jacoco.agent.rt_6qyg3i.core.data.SessionInfo;
import org.jacoco.agent.rt_6qyg3i.core.internal.data.CompactDataOutput;

public class ExecutionDataWriter
implements ISessionInfoVisitor,
IExecutionDataVisitor {
    public static final char FORMAT_VERSION = '\u1006';
    public static final char MAGIC_NUMBER = '\uc0c0';
    public static final byte BLOCK_HEADER = 1;
    public static final byte BLOCK_SESSIONINFO = 16;
    public static final byte BLOCK_EXECUTIONDATA = 17;
    protected final CompactDataOutput out;

    public ExecutionDataWriter(OutputStream output) throws IOException {
        this.out = new CompactDataOutput(output);
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        this.out.writeByte(1);
        this.out.writeChar(49344);
        this.out.writeChar(4102);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void visitSessionInfo(SessionInfo info) {
        try {
            this.out.writeByte(16);
            this.out.writeUTF(info.getId());
            this.out.writeLong(info.getStartTimeStamp());
            this.out.writeLong(info.getDumpTimeStamp());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void visitClassExecution(ExecutionData data) {
        try {
            this.out.writeByte(17);
            this.out.writeLong(data.getId());
            this.out.writeUTF(data.getName());
            this.out.writeBooleanArray(data.getData());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final byte[] getFileHeader() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            new ExecutionDataWriter(buffer);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return buffer.toByteArray();
    }
}

