/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_6qyg3i.core.internal.flow;

import org.jacoco.agent.rt_6qyg3i.asm.Label;
import org.jacoco.agent.rt_6qyg3i.core.internal.flow.Instruction;

public final class LabelInfo {
    public static final int NO_PROBE = -1;
    private boolean target = false;
    private boolean multiTarget = false;
    private boolean successor = false;
    private boolean done = false;
    private int probeid = -1;
    private Label intermediate = null;
    private Instruction instruction = null;

    private LabelInfo() {
    }

    public static void setTarget(Label label) {
        LabelInfo info = LabelInfo.create(label);
        if (info.target || info.successor) {
            info.multiTarget = true;
        } else {
            info.target = true;
        }
    }

    public static void setSuccessor(Label label) {
        LabelInfo info = LabelInfo.create(label);
        info.successor = true;
        if (info.target) {
            info.multiTarget = true;
        }
    }

    public static boolean isMultiTarget(Label label) {
        LabelInfo info = LabelInfo.get(label);
        return info == null ? false : info.multiTarget;
    }

    public static boolean isSuccessor(Label label) {
        LabelInfo info = LabelInfo.get(label);
        return info == null ? false : info.successor;
    }

    public static void setDone(Label label) {
        LabelInfo.create((Label)label).done = true;
    }

    public static void resetDone(Label label) {
        LabelInfo info = LabelInfo.get(label);
        if (info != null) {
            info.done = false;
        }
    }

    public static void resetDone(Label[] labels) {
        Label[] labelArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            Label label = labelArray[n2];
            LabelInfo.resetDone(label);
            ++n2;
        }
    }

    public static boolean isDone(Label label) {
        LabelInfo info = LabelInfo.get(label);
        return info == null ? false : info.done;
    }

    public static void setProbeId(Label label, int id) {
        LabelInfo.create((Label)label).probeid = id;
    }

    public static int getProbeId(Label label) {
        LabelInfo info = LabelInfo.get(label);
        return info == null ? -1 : info.probeid;
    }

    public static void setIntermediateLabel(Label label, Label intermediate) {
        LabelInfo.create((Label)label).intermediate = intermediate;
    }

    public static Label getIntermediateLabel(Label label) {
        LabelInfo info = LabelInfo.get(label);
        return info == null ? null : info.intermediate;
    }

    public static void setInstruction(Label label, Instruction instruction) {
        LabelInfo.create((Label)label).instruction = instruction;
    }

    public static Instruction getInstruction(Label label) {
        LabelInfo info = LabelInfo.get(label);
        return info == null ? null : info.instruction;
    }

    private static LabelInfo get(Label label) {
        Object info = label.info;
        return info instanceof LabelInfo ? (LabelInfo)info : null;
    }

    private static LabelInfo create(Label label) {
        LabelInfo info = LabelInfo.get(label);
        if (info == null) {
            info = new LabelInfo();
            label.info = info;
        }
        return info;
    }
}

