/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_6qyg3i.core.internal.flow;

import org.jacoco.agent.rt_6qyg3i.asm.Label;
import org.jacoco.agent.rt_6qyg3i.asm.MethodAdapter;
import org.jacoco.agent.rt_6qyg3i.core.internal.flow.IMethodProbesVisitor;
import org.jacoco.agent.rt_6qyg3i.core.internal.flow.IProbeIdGenerator;
import org.jacoco.agent.rt_6qyg3i.core.internal.flow.LabelInfo;

public final class MethodProbesAdapter
extends MethodAdapter {
    private final IMethodProbesVisitor probesVisitor;
    private final IProbeIdGenerator idGenerator;

    public MethodProbesAdapter(IMethodProbesVisitor probesVisitor, IProbeIdGenerator idGenerator) {
        super(probesVisitor);
        this.probesVisitor = probesVisitor;
        this.idGenerator = idGenerator;
    }

    public void visitLabel(Label label) {
        if (LabelInfo.isMultiTarget(label) && LabelInfo.isSuccessor(label)) {
            this.probesVisitor.visitProbe(this.idGenerator.nextId());
        }
        this.probesVisitor.visitLabel(label);
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                this.probesVisitor.visitInsnWithProbe(opcode, this.idGenerator.nextId());
                break;
            }
            default: {
                this.probesVisitor.visitInsn(opcode);
            }
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (LabelInfo.isMultiTarget(label)) {
            this.probesVisitor.visitJumpInsnWithProbe(opcode, label, this.idGenerator.nextId());
        } else {
            this.probesVisitor.visitJumpInsn(opcode, label);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (this.markLabels(dflt, labels)) {
            this.probesVisitor.visitLookupSwitchInsnWithProbes(dflt, keys, labels);
        } else {
            this.probesVisitor.visitLookupSwitchInsn(dflt, keys, labels);
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        if (this.markLabels(dflt, labels)) {
            this.probesVisitor.visitTableSwitchInsnWithProbes(min, max, dflt, labels);
        } else {
            this.probesVisitor.visitTableSwitchInsn(min, max, dflt, labels);
        }
    }

    private boolean markLabels(Label dflt, Label[] labels) {
        boolean probe = false;
        LabelInfo.resetDone(labels);
        if (LabelInfo.isMultiTarget(dflt)) {
            LabelInfo.setProbeId(dflt, this.idGenerator.nextId());
            probe = true;
        }
        LabelInfo.setDone(dflt);
        Label[] labelArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            Label l = labelArray[n2];
            if (!LabelInfo.isDone(l) && LabelInfo.isMultiTarget(l)) {
                LabelInfo.setProbeId(l, this.idGenerator.nextId());
                probe = true;
            }
            LabelInfo.setDone(l);
            ++n2;
        }
        return probe;
    }
}

