/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_9w37ty;

import java.lang.instrument.Instrumentation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jacoco.agent.rt_9w37ty.CoverageTransformer;
import org.jacoco.agent.rt_9w37ty.IExceptionLogger;
import org.jacoco.agent.rt_9w37ty.controller.IAgentController;
import org.jacoco.agent.rt_9w37ty.controller.LocalController;
import org.jacoco.agent.rt_9w37ty.controller.MBeanController;
import org.jacoco.agent.rt_9w37ty.controller.TcpClientController;
import org.jacoco.agent.rt_9w37ty.controller.TcpServerController;
import org.jacoco.agent.rt_9w37ty.core.runtime.AbstractRuntime;
import org.jacoco.agent.rt_9w37ty.core.runtime.AgentOptions;
import org.jacoco.agent.rt_9w37ty.core.runtime.IRuntime;
import org.jacoco.agent.rt_9w37ty.core.runtime.ModifiedSystemClassRuntime;

public class JacocoAgent {
    private final AgentOptions options;
    private final IExceptionLogger logger;
    private IAgentController controller;

    public JacocoAgent(AgentOptions options, IExceptionLogger logger) {
        this.options = options;
        this.logger = logger;
    }

    public JacocoAgent(String options, IExceptionLogger logger) {
        this(new AgentOptions(options), logger);
    }

    public void init(Instrumentation inst) throws Exception {
        IRuntime runtime = this.createRuntime(inst);
        String sessionId = this.options.getSessionId();
        if (sessionId == null) {
            sessionId = this.createSessionId();
        }
        runtime.setSessionId(sessionId);
        runtime.startup();
        inst.addTransformer(new CoverageTransformer(runtime, this.options, this.logger));
        this.controller = this.createAgentController();
        this.controller.startup(this.options, runtime);
    }

    protected IAgentController createAgentController() {
        AgentOptions.OutputMode controllerType = this.options.getOutput();
        switch (controllerType) {
            case file: {
                return new LocalController();
            }
            case tcpserver: {
                return new TcpServerController(this.logger);
            }
            case tcpclient: {
                return new TcpClientController(this.logger);
            }
            case mbean: {
                return new MBeanController();
            }
        }
        throw new AssertionError((Object)controllerType);
    }

    private String createSessionId() {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "unknownhost";
        }
        return host + "-" + AbstractRuntime.createRandomId();
    }

    protected IRuntime createRuntime(Instrumentation inst) throws Exception {
        return ModifiedSystemClassRuntime.createFor(inst, "java/util/UUID");
    }

    public void shutdown() {
        try {
            if (this.options.getDumpOnExit()) {
                this.controller.writeExecutionData();
            }
            this.controller.shutdown();
        }
        catch (Exception e) {
            this.logger.logExeption(e);
        }
    }

    public static void premain(String options, Instrumentation inst) throws Exception {
        final JacocoAgent agent = new JacocoAgent(options, new IExceptionLogger(){

            public void logExeption(Exception ex) {
                ex.printStackTrace();
            }
        });
        agent.init(inst);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                agent.shutdown();
            }
        });
    }
}

