/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_9w37ty.controller;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jacoco.agent.rt_9w37ty.controller.IAgentController;
import org.jacoco.agent.rt_9w37ty.controller.IRuntimeMBean;
import org.jacoco.agent.rt_9w37ty.core.JaCoCo;
import org.jacoco.agent.rt_9w37ty.core.data.ExecutionDataWriter;
import org.jacoco.agent.rt_9w37ty.core.runtime.AgentOptions;
import org.jacoco.agent.rt_9w37ty.core.runtime.IRuntime;

public class MBeanController
implements IAgentController,
IRuntimeMBean {
    private static final String OBJECT_NAME = "org.jacoco:type=Runtime";
    private IRuntime runtime;

    public void startup(AgentOptions options, IRuntime runtime) throws Exception {
        this.runtime = runtime;
        ManagementFactory.getPlatformMBeanServer().registerMBean(new StandardMBean(this, IRuntimeMBean.class), new ObjectName(OBJECT_NAME));
    }

    public void shutdown() throws Exception {
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(OBJECT_NAME));
    }

    public void writeExecutionData() throws Exception {
    }

    public String getVersion() {
        return JaCoCo.VERSION;
    }

    public String getSessionId() {
        return this.runtime.getSessionId();
    }

    public void setSessionId(String id) {
        this.runtime.setSessionId(id);
    }

    public byte[] dump(boolean reset) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ExecutionDataWriter writer = new ExecutionDataWriter(output);
        this.runtime.collect(writer, writer, reset);
        return output.toByteArray();
    }

    public void reset() {
        this.runtime.reset();
    }
}

