/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_9w37ty.core.internal.instr;

import java.util.HashMap;
import java.util.Map;
import org.jacoco.agent.rt_9w37ty.asm.Label;
import org.jacoco.agent.rt_9w37ty.asm.MethodAdapter;
import org.jacoco.agent.rt_9w37ty.asm.MethodVisitor;
import org.jacoco.agent.rt_9w37ty.asm.Type;
import org.jacoco.agent.rt_9w37ty.asm.tree.FrameNode;
import org.jacoco.agent.rt_9w37ty.core.internal.flow.LabelInfo;

class ProbeVariableInserter
extends MethodAdapter {
    protected final int variable;
    private final int variableIdx;
    private boolean firstFrame = true;
    private Label lastLabel;
    private Map<Label, FrameNode> probeFrames;

    ProbeVariableInserter(int access, String desc, MethodVisitor mv) {
        super(mv);
        int idx;
        int pos = idx = (8 & access) == 0 ? 1 : 0;
        Type[] typeArray = Type.getArgumentTypes(desc);
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            ++idx;
            pos += t.getSize();
            ++n2;
        }
        this.variableIdx = idx;
        this.variable = pos;
        this.lastLabel = null;
    }

    public void visitLabel(Label label) {
        this.mv.visitLabel(label);
        this.lastLabel = label;
    }

    public void visitVarInsn(int opcode, int var) {
        this.mv.visitVarInsn(opcode, this.map(var));
    }

    public void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(this.map(var), increment);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack, maxLocals + 1);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.mv.visitLocalVariable(name, desc, signature, start, end, this.map(index));
    }

    private int map(int var) {
        if (var < this.variable) {
            return var;
        }
        return var + 1;
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (type != -1) {
            throw new IllegalStateException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        Object[] newLocal = new Object[nLocal + 1];
        int i = 0;
        while (i <= local.length) {
            newLocal[i] = i < this.variableIdx ? local[i] : (i > this.variableIdx ? local[i - 1] : "[Z");
            ++i;
        }
        if (this.lastLabel != null) {
            if (LabelInfo.isMultiTarget(this.lastLabel)) {
                if (this.probeFrames == null) {
                    this.probeFrames = new HashMap<Label, FrameNode>();
                }
                this.probeFrames.put(this.lastLabel, new FrameNode(type, nLocal + 1, newLocal, nStack, stack));
            }
            this.lastLabel = null;
        }
        if (this.firstFrame) {
            this.mv.visitFrame(type, nLocal, local, nStack, stack);
            this.firstFrame = false;
        } else {
            this.mv.visitFrame(type, nLocal + 1, newLocal, nStack, stack);
        }
    }

    protected void insertProbeFrame(Label label) {
        FrameNode frame;
        if (this.probeFrames != null && (frame = this.probeFrames.get(label)) != null) {
            frame.accept(this.mv);
        }
    }
}

