/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_6effb9e.core.internal.flow;

import org.jacoco.agent.rt.internal_6effb9e.asm.Label;
import org.jacoco.agent.rt.internal_6effb9e.asm.MethodVisitor;
import org.jacoco.agent.rt.internal_6effb9e.core.internal.flow.IProbeIdGenerator;
import org.jacoco.agent.rt.internal_6effb9e.core.internal.flow.LabelInfo;
import org.jacoco.agent.rt.internal_6effb9e.core.internal.flow.MethodProbesVisitor;

public final class MethodProbesAdapter
extends MethodVisitor {
    private final MethodProbesVisitor probesVisitor;
    private final IProbeIdGenerator idGenerator;

    public MethodProbesAdapter(MethodProbesVisitor probesVisitor, IProbeIdGenerator idGenerator) {
        super(262144, probesVisitor);
        this.probesVisitor = probesVisitor;
        this.idGenerator = idGenerator;
    }

    public void visitLabel(Label label) {
        if (LabelInfo.isMultiTarget(label) && LabelInfo.isSuccessor(label)) {
            this.probesVisitor.visitProbe(this.idGenerator.nextId());
        }
        this.probesVisitor.visitLabel(label);
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                this.probesVisitor.visitInsnWithProbe(opcode, this.idGenerator.nextId());
                break;
            }
            default: {
                this.probesVisitor.visitInsn(opcode);
            }
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (LabelInfo.isMultiTarget(label)) {
            this.probesVisitor.visitJumpInsnWithProbe(opcode, label, this.idGenerator.nextId());
        } else {
            this.probesVisitor.visitJumpInsn(opcode, label);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (this.markLabels(dflt, labels)) {
            this.probesVisitor.visitLookupSwitchInsnWithProbes(dflt, keys, labels);
        } else {
            this.probesVisitor.visitLookupSwitchInsn(dflt, keys, labels);
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        if (this.markLabels(dflt, labels)) {
            this.probesVisitor.visitTableSwitchInsnWithProbes(min, max, dflt, labels);
        } else {
            this.probesVisitor.visitTableSwitchInsn(min, max, dflt, labels);
        }
    }

    private boolean markLabels(Label dflt, Label[] labels) {
        boolean probe = false;
        LabelInfo.resetDone(labels);
        if (LabelInfo.isMultiTarget(dflt)) {
            LabelInfo.setProbeId(dflt, this.idGenerator.nextId());
            probe = true;
        }
        LabelInfo.setDone(dflt);
        for (Label l : labels) {
            if (!LabelInfo.isDone(l) && LabelInfo.isMultiTarget(l)) {
                LabelInfo.setProbeId(l, this.idGenerator.nextId());
                probe = true;
            }
            LabelInfo.setDone(l);
        }
        return probe;
    }
}

