/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.ant;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.jacoco.ant.AbstractCoverageTask;

public class CoverageTask
extends AbstractCoverageTask
implements TaskContainer {
    private final Collection<TaskEnhancer> taskEnhancers = new ArrayList<TaskEnhancer>();
    private Task childTask;

    public CoverageTask() {
        this.taskEnhancers.add(new JavaLikeTaskEnhancer("java"));
        this.taskEnhancers.add(new JavaLikeTaskEnhancer("junit"));
        this.taskEnhancers.add(new TestNGTaskEnhancer("testng"));
    }

    public void addTask(Task task) {
        if (this.childTask != null) {
            throw new BuildException("Only one child task can be supplied to the coverge task");
        }
        this.childTask = task;
        String subTaskTypeName = task.getTaskType();
        TaskEnhancer enhancer = this.findEnhancerForTask(subTaskTypeName);
        if (enhancer == null) {
            throw new BuildException(String.format("%s is not a valid child of the coverage task.", subTaskTypeName));
        }
        if (this.isEnabled()) {
            this.log(String.format("Enhancing %s with coverage.", this.childTask.getTaskName()));
            enhancer.enhanceTask(task);
        }
        task.maybeConfigure();
    }

    private TaskEnhancer findEnhancerForTask(String taskName) {
        for (TaskEnhancer enhancer : this.taskEnhancers) {
            if (!enhancer.supportsTask(taskName)) continue;
            return enhancer;
        }
        return null;
    }

    public void execute() throws BuildException {
        if (this.childTask == null) {
            throw new BuildException("A child task must be supplied for the coverage task");
        }
        this.childTask.execute();
    }

    private class JavaLikeTaskEnhancer
    implements TaskEnhancer {
        private final String supportedTaskName;

        public JavaLikeTaskEnhancer(String supportedTaskName) {
            this.supportedTaskName = supportedTaskName;
        }

        public boolean supportsTask(String taskname) {
            return taskname.equals(this.supportedTaskName);
        }

        public void enhanceTask(Task task) {
            RuntimeConfigurable configurableWrapper = task.getRuntimeConfigurableWrapper();
            String forkValue = (String)configurableWrapper.getAttributeMap().get("fork");
            if (forkValue == null || !Project.toBoolean((String)forkValue)) {
                throw new BuildException("Coverage can only be applied on a forked VM");
            }
            this.addJvmArgs(task);
        }

        public void addJvmArgs(Task task) {
            UnknownElement el = new UnknownElement("jvmarg");
            el.setTaskName("jvmarg");
            el.setQName("jvmarg");
            RuntimeConfigurable runtimeConfigurableWrapper = el.getRuntimeConfigurableWrapper();
            runtimeConfigurableWrapper.setAttribute("value", CoverageTask.this.getLaunchingArgument());
            task.getRuntimeConfigurableWrapper().addChild(runtimeConfigurableWrapper);
            ((UnknownElement)task).addChild(el);
        }
    }

    private static interface TaskEnhancer {
        public boolean supportsTask(String var1);

        public void enhanceTask(Task var1) throws BuildException;
    }

    private class TestNGTaskEnhancer
    extends JavaLikeTaskEnhancer {
        public TestNGTaskEnhancer(String supportedTaskName) {
            super(supportedTaskName);
        }

        public void enhanceTask(Task task) {
            this.addJvmArgs(task);
        }
    }
}

