/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.runtime.AgentOptions;
import org.jacoco.core.runtime.RemoteControlReader;
import org.jacoco.core.runtime.RemoteControlWriter;

public class DumpTask
extends Task {
    private boolean dump = true;
    private boolean reset = false;
    private File destfile = null;
    private String address = AgentOptions.DEFAULT_ADDRESS;
    private int port = 6300;
    private boolean append = true;

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPort(int port) {
        if (port <= 0) {
            throw new BuildException("Invalid port value");
        }
        this.port = port;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public void execute() throws BuildException {
        OutputStream output = null;
        try {
            try {
                if (this.dump) {
                    if (this.destfile == null) {
                        throw new BuildException("Destination file is required when dumping execution data");
                    }
                    FileUtils.getFileUtils().createNewFile(this.destfile, true);
                    output = new FileOutputStream(this.destfile, this.append);
                } else {
                    output = new Nul();
                }
                Socket socket = new Socket(InetAddress.getByName(this.address), this.port);
                RemoteControlWriter remoteWriter = new RemoteControlWriter(socket.getOutputStream());
                RemoteControlReader remoteReader = new RemoteControlReader(socket.getInputStream());
                ExecutionDataWriter outputWriter = new ExecutionDataWriter(output);
                remoteReader.setSessionInfoVisitor((ISessionInfoVisitor)outputWriter);
                remoteReader.setExecutionDataVisitor((IExecutionDataVisitor)outputWriter);
                remoteWriter.visitDumpCommand(this.dump, this.reset);
                remoteReader.read();
                socket.close();
            }
            catch (IOException e) {
                throw new BuildException("Unable to dump coverage data", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(output);
            throw throwable;
        }
        FileUtils.close((OutputStream)output);
    }

    private static class Nul
    extends OutputStream {
        private Nul() {
        }

        public void write(int b) throws IOException {
        }
    }
}

