/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.ZipMultiReportOutput;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

public class ReportTask
extends Task {
    private final Union executiondataElement = new Union();
    private SessionInfoStore sessionInfoStore;
    private ExecutionDataStore executionDataStore;
    private final GroupElement structure = new GroupElement();
    private final List<IFormatterElement> formatters = new ArrayList<IFormatterElement>();

    public Union createExecutiondata() {
        return this.executiondataElement;
    }

    public GroupElement createStructure() {
        return this.structure;
    }

    public HTMLFormatterElement createHtml() {
        HTMLFormatterElement element = new HTMLFormatterElement();
        this.formatters.add(element);
        return element;
    }

    public CSVFormatterElement createCsv() {
        CSVFormatterElement element = new CSVFormatterElement();
        this.formatters.add(element);
        return element;
    }

    public XMLFormatterElement createXml() {
        XMLFormatterElement element = new XMLFormatterElement();
        this.formatters.add(element);
        return element;
    }

    public void execute() throws BuildException {
        this.loadExecutionData();
        try {
            IReportVisitor visitor = this.createVisitor();
            visitor.visitInfo(this.sessionInfoStore.getInfos(), this.executionDataStore.getContents());
            this.createReport((IReportGroupVisitor)visitor, this.structure);
            visitor.visitEnd();
        }
        catch (IOException e) {
            throw new BuildException("Error while creating report.", (Throwable)e);
        }
    }

    private void loadExecutionData() {
        this.sessionInfoStore = new SessionInfoStore();
        this.executionDataStore = new ExecutionDataStore();
        for (Resource resource : this.executiondataElement) {
            BufferedInputStream in = null;
            try {
                try {
                    in = new BufferedInputStream(resource.getInputStream());
                    ExecutionDataReader reader = new ExecutionDataReader((InputStream)in);
                    reader.setSessionInfoVisitor((ISessionInfoVisitor)this.sessionInfoStore);
                    reader.setExecutionDataVisitor((IExecutionDataVisitor)this.executionDataStore);
                    reader.read();
                }
                catch (IOException e) {
                    throw new BuildException("Unable to read execution data file " + resource.getName(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(in);
                throw throwable;
            }
            FileUtils.close((InputStream)in);
        }
    }

    private IReportVisitor createVisitor() throws IOException {
        ArrayList<IReportVisitor> visitors = new ArrayList<IReportVisitor>();
        for (IFormatterElement f : this.formatters) {
            visitors.add(f.createVisitor());
        }
        return new MultiReportVisitor(visitors);
    }

    private void createReport(IReportGroupVisitor visitor, GroupElement group) throws IOException {
        if (group.name == null) {
            throw new BuildException("Group name must be supplied");
        }
        if (group.children.size() > 0) {
            IReportGroupVisitor groupVisitor = visitor.visitGroup(group.name);
            for (GroupElement child : group.children) {
                this.createReport(groupVisitor, child);
            }
        } else {
            IBundleCoverage bundle = this.createBundle(group);
            SourceFileCollection locator = new SourceFileCollection(group.sourcefiles);
            if (!locator.isEmpty()) {
                this.checkForMissingDebugInformation((ICoverageNode)bundle);
            }
            visitor.visitBundle(bundle, (ISourceFileLocator)locator);
        }
    }

    private IBundleCoverage createBundle(GroupElement group) throws IOException {
        CoverageBuilder builder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.executionDataStore, (ICoverageVisitor)builder);
        for (Resource resource : group.classfiles) {
            if (resource.isDirectory() && resource instanceof FileResource) {
                analyzer.analyzeAll(((FileResource)resource).getFile());
                continue;
            }
            InputStream in = resource.getInputStream();
            analyzer.analyzeAll(in);
            in.close();
        }
        return builder.getBundle(group.name);
    }

    private void checkForMissingDebugInformation(ICoverageNode node) {
        if (node.getClassCounter().getTotalCount() > 0 && node.getLineCounter().getTotalCount() == 0) {
            this.log(String.format("To enable source code annotation class files for bundle '%s' have to be compiled with debug information.", node.getName()), 1);
        }
    }

    public static class CSVFormatterElement
    implements IFormatterElement {
        private File destfile;
        private String encoding = "UTF-8";

        public void setDestfile(File destfile) {
            this.destfile = destfile;
        }

        public IReportVisitor createVisitor() throws IOException {
            if (this.destfile == null) {
                throw new BuildException("Destination file must be supplied for csv report");
            }
            CSVFormatter formatter = new CSVFormatter();
            formatter.setOutputEncoding(this.encoding);
            return formatter.createVisitor((OutputStream)new FileOutputStream(this.destfile));
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }
    }

    public static class GroupElement {
        private final List<GroupElement> children = new ArrayList<GroupElement>();
        private final Union classfiles = new Union();
        private final SourceFilesElement sourcefiles = new SourceFilesElement();
        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public GroupElement createGroup() {
            GroupElement group = new GroupElement();
            this.children.add(group);
            return group;
        }

        public Union createClassfiles() {
            return this.classfiles;
        }

        public SourceFilesElement createSourcefiles() {
            return this.sourcefiles;
        }
    }

    public static class HTMLFormatterElement
    implements IFormatterElement {
        private File destdir;
        private File destfile;
        private String footer = "";
        private String encoding = "UTF-8";
        private Locale locale = Locale.getDefault();

        public void setDestdir(File destdir) {
            this.destdir = destdir;
        }

        public void setDestfile(File destfile) {
            this.destfile = destfile;
        }

        public void setFooter(String text) {
            this.footer = text;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public IReportVisitor createVisitor() throws IOException {
            FileMultiReportOutput output;
            if (this.destfile != null) {
                if (this.destdir != null) {
                    throw new BuildException("Either destination directory or file must be supplied, not both");
                }
                FileOutputStream stream = new FileOutputStream(this.destfile);
                output = new ZipMultiReportOutput((OutputStream)stream);
            } else {
                if (this.destdir == null) {
                    throw new BuildException("Destination directory or file must be supplied for html report");
                }
                output = new FileMultiReportOutput(this.destdir);
            }
            HTMLFormatter formatter = new HTMLFormatter();
            formatter.setFooterText(this.footer);
            formatter.setOutputEncoding(this.encoding);
            formatter.setLocale(this.locale);
            return formatter.createVisitor((IMultiReportOutput)output);
        }
    }

    private static interface IFormatterElement {
        public IReportVisitor createVisitor() throws IOException;
    }

    private static class SourceFileCollection
    implements ISourceFileLocator {
        private final String encoding;
        private final Map<String, Resource> resources = new HashMap<String, Resource>();
        private final int tabWidth;

        SourceFileCollection(SourceFilesElement sourceFiles) {
            this.encoding = sourceFiles.encoding;
            this.tabWidth = sourceFiles.tabWidth;
            Iterator i = sourceFiles.iterator();
            while (i.hasNext()) {
                Resource r = (Resource)i.next();
                this.resources.put(r.getName().replace(File.separatorChar, '/'), r);
            }
        }

        public Reader getSourceFile(String packageName, String fileName) throws IOException {
            Resource r = packageName.length() > 0 ? this.resources.get(String.valueOf(packageName) + '/' + fileName) : this.resources.get(fileName);
            if (r == null) {
                return null;
            }
            if (this.encoding == null) {
                return new InputStreamReader(r.getInputStream());
            }
            return new InputStreamReader(r.getInputStream(), this.encoding);
        }

        public int getTabWidth() {
            return this.tabWidth;
        }

        public boolean isEmpty() {
            return this.resources.isEmpty();
        }
    }

    public static class SourceFilesElement
    extends Union {
        String encoding = null;
        int tabWidth = 4;

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void setTabwidth(int tabWidth) {
            if (tabWidth <= 0) {
                throw new BuildException("Tab width must be greater than 0");
            }
            this.tabWidth = tabWidth;
        }
    }

    public static class XMLFormatterElement
    implements IFormatterElement {
        private File destfile;
        private String encoding = "UTF-8";

        public void setDestfile(File destfile) {
            this.destfile = destfile;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public IReportVisitor createVisitor() throws IOException {
            if (this.destfile == null) {
                throw new BuildException("Destination file must be supplied for xml report");
            }
            XMLFormatter formatter = new XMLFormatter();
            formatter.setOutputEncoding(this.encoding);
            return formatter.createVisitor((OutputStream)new FileOutputStream(this.destfile));
        }
    }
}

