/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.analysis;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.internal.analysis.BundleCoverageImpl;
import org.jacoco.core.internal.analysis.SourceFileCoverageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageBuilder
implements ICoverageVisitor {
    private final Map<String, IClassCoverage> classes = new HashMap<String, IClassCoverage>();
    private final Map<String, ISourceFileCoverage> sourcefiles = new HashMap<String, ISourceFileCoverage>();

    public Collection<IClassCoverage> getClasses() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    public Collection<ISourceFileCoverage> getSourceFiles() {
        return Collections.unmodifiableCollection(this.sourcefiles.values());
    }

    public BundleCoverageImpl getBundle(String name) {
        return new BundleCoverageImpl(name, this.classes.values(), this.sourcefiles.values());
    }

    @Override
    public void visitCoverage(IClassCoverage coverage) {
        if (coverage.getInstructionCounter().getTotalCount() > 0) {
            String name = coverage.getName();
            IClassCoverage dup = this.classes.put(name, coverage);
            if (dup != null && dup.getId() != coverage.getId()) {
                throw new IllegalStateException("Can't add different class with same name: " + name);
            }
            String source = coverage.getSourceFileName();
            if (source != null) {
                SourceFileCoverageImpl sourceFile = this.getSourceFile(source, coverage.getPackageName());
                sourceFile.increment(coverage);
            }
        }
    }

    private SourceFileCoverageImpl getSourceFile(String filename, String packagename) {
        String key = String.valueOf(packagename) + '/' + filename;
        SourceFileCoverageImpl sourcefile = (SourceFileCoverageImpl)this.sourcefiles.get(key);
        if (sourcefile == null) {
            sourcefile = new SourceFileCoverageImpl(filename, packagename);
            this.sourcefiles.put(key, sourcefile);
        }
        return sourcefile;
    }
}

