/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.internal.analysis.ClassCoverageImpl;
import org.jacoco.core.internal.analysis.MethodAnalyzer;
import org.jacoco.core.internal.analysis.StringPool;
import org.jacoco.core.internal.flow.IClassProbesVisitor;
import org.jacoco.core.internal.flow.IMethodProbesVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.FieldVisitor;

public class ClassAnalyzer
implements IClassProbesVisitor {
    private final long classid;
    private final boolean[] executionData;
    private final StringPool stringPool;
    private ClassCoverageImpl coverage;

    public ClassAnalyzer(long classid, boolean[] executionData, StringPool stringPool) {
        this.classid = classid;
        this.executionData = executionData;
        this.stringPool = stringPool;
    }

    public ClassCoverageImpl getCoverage() {
        return this.coverage;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.coverage = new ClassCoverageImpl(this.stringPool.get(name), this.classid, this.stringPool.get(signature), this.stringPool.get(superName), this.stringPool.get(interfaces));
    }

    public void visitSource(String source, String debug) {
        this.coverage.setSourceFileName(this.stringPool.get(source));
    }

    public IMethodProbesVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x1000) != 0) {
            return null;
        }
        return new MethodAnalyzer(this.stringPool.get(name), this.stringPool.get(desc), this.stringPool.get(signature), this.executionData){

            public void visitEnd() {
                super.visitEnd();
                IMethodCoverage methodCoverage = this.getCoverage();
                if (methodCoverage.getInstructionCounter().getTotalCount() > 0) {
                    ClassAnalyzer.this.coverage.addMethod(methodCoverage);
                }
            }
        };
    }

    public void visitTotalProbeCount(int count) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitEnd() {
    }
}

