/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import java.util.ArrayList;
import java.util.List;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.internal.analysis.CounterImpl;
import org.jacoco.core.internal.analysis.MethodCoverageImpl;
import org.jacoco.core.internal.flow.IMethodProbesVisitor;
import org.jacoco.core.internal.flow.Instruction;
import org.jacoco.core.internal.flow.LabelInfo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;

public class MethodAnalyzer
implements IMethodProbesVisitor {
    private final boolean[] executionData;
    private final MethodCoverageImpl coverage;
    private int currentLine = -1;
    private int firstLine = -1;
    private int lastLine = -1;
    private final List<Label> currentLabel = new ArrayList<Label>(2);
    private final List<Instruction> instructions = new ArrayList<Instruction>();
    private final List<Instruction> coveredProbes = new ArrayList<Instruction>();
    private final List<Jump> jumps = new ArrayList<Jump>();
    private Instruction lastInsn;

    public MethodAnalyzer(String name, String desc, String signature, boolean[] executionData) {
        this.executionData = executionData;
        this.coverage = new MethodCoverageImpl(name, desc, signature);
    }

    public IMethodCoverage getCoverage() {
        return this.coverage;
    }

    public void visitLabel(Label label) {
        this.currentLabel.add(label);
        if (!LabelInfo.isSuccessor(label)) {
            this.lastInsn = null;
        }
    }

    public void visitLineNumber(int line, Label start) {
        this.currentLine = line;
        if (this.firstLine > line || this.lastLine == -1) {
            this.firstLine = line;
        }
        if (this.lastLine < line) {
            this.lastLine = line;
        }
    }

    private void visitInsn() {
        int labelCount;
        Instruction insn = new Instruction(this.currentLine);
        this.instructions.add(insn);
        if (this.lastInsn != null) {
            insn.setPredecessor(this.lastInsn);
        }
        if ((labelCount = this.currentLabel.size()) > 0) {
            int i = labelCount;
            while (--i >= 0) {
                LabelInfo.setInstruction(this.currentLabel.get(i), insn);
            }
            this.currentLabel.clear();
        }
        this.lastInsn = insn;
    }

    public void visitInsn(int opcode) {
        this.visitInsn();
    }

    public void visitIntInsn(int opcode, int operand) {
        this.visitInsn();
    }

    public void visitVarInsn(int opcode, int var) {
        this.visitInsn();
    }

    public void visitTypeInsn(int opcode, String type) {
        this.visitInsn();
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.visitInsn();
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.visitInsn();
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.visitInsn();
        this.jumps.add(new Jump(this.lastInsn, label));
    }

    public void visitLdcInsn(Object cst) {
        this.visitInsn();
    }

    public void visitIincInsn(int var, int increment) {
        this.visitInsn();
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.visitSwitchInsn(dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.visitSwitchInsn(dflt, labels);
    }

    private void visitSwitchInsn(Label dflt, Label[] labels) {
        this.visitInsn();
        LabelInfo.resetDone(labels);
        this.jumps.add(new Jump(this.lastInsn, dflt));
        LabelInfo.setDone(dflt);
        Label[] labelArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            Label l = labelArray[n2];
            if (!LabelInfo.isDone(l)) {
                this.jumps.add(new Jump(this.lastInsn, l));
                LabelInfo.setDone(l);
            }
            ++n2;
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.visitInsn();
    }

    public void visitProbe(int probeId) {
        this.addProbe(probeId);
        this.lastInsn = null;
    }

    public void visitJumpInsnWithProbe(int opcode, Label label, int probeId) {
        this.visitInsn();
        this.addProbe(probeId);
    }

    public void visitInsnWithProbe(int opcode, int probeId) {
        this.visitInsn();
        this.addProbe(probeId);
    }

    public void visitTableSwitchInsnWithProbes(int min, int max, Label dflt, Label[] labels) {
        this.visitSwitchInsnWithProbes(dflt, labels);
    }

    public void visitLookupSwitchInsnWithProbes(Label dflt, int[] keys, Label[] labels) {
        this.visitSwitchInsnWithProbes(dflt, labels);
    }

    private void visitSwitchInsnWithProbes(Label dflt, Label[] labels) {
        this.visitInsn();
        LabelInfo.resetDone(dflt);
        LabelInfo.resetDone(labels);
        this.visitSwitchTarget(dflt);
        Label[] labelArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            Label l = labelArray[n2];
            this.visitSwitchTarget(l);
            ++n2;
        }
    }

    private void visitSwitchTarget(Label label) {
        int id = LabelInfo.getProbeId(label);
        if (!LabelInfo.isDone(label)) {
            if (id == -1) {
                this.jumps.add(new Jump(this.lastInsn, label));
            } else {
                this.addProbe(id);
            }
            LabelInfo.setDone(label);
        }
    }

    public void visitEnd() {
        for (Jump j : this.jumps) {
            LabelInfo.getInstruction(j.target).setPredecessor(j.source);
        }
        for (Instruction p : this.coveredProbes) {
            p.setCovered();
        }
        this.coverage.ensureCapacity(this.firstLine, this.lastLine);
        for (Instruction i : this.instructions) {
            int total = i.getBranches();
            int covered = i.getCoveredBranches();
            CounterImpl instrCounter = covered == 0 ? CounterImpl.COUNTER_1_0 : CounterImpl.COUNTER_0_1;
            CounterImpl branchCounter = total > 1 ? CounterImpl.getInstance(total - covered, covered) : CounterImpl.COUNTER_0_0;
            this.coverage.increment(instrCounter, branchCounter, i.getLine());
        }
        this.coverage.incrementMethodCounter();
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return null;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitCode() {
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    public void visitMaxs(int maxStack, int maxLocals) {
    }

    private void addProbe(int probeId) {
        this.lastInsn.addBranch();
        if (this.executionData != null && this.executionData[probeId]) {
            this.coveredProbes.add(this.lastInsn);
        }
    }

    private static class Jump {
        final Instruction source;
        final Label target;

        Jump(Instruction source, Label target) {
            this.source = source;
            this.target = target;
        }
    }
}

