/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import org.jacoco.core.analysis.ICounter;

public abstract class CounterImpl
implements ICounter {
    private static final int SINGLETON_LIMIT = 30;
    private static final CounterImpl[][] SINGLETONS = new CounterImpl[31][];
    public static final CounterImpl COUNTER_0_0;
    public static final CounterImpl COUNTER_1_0;
    public static final CounterImpl COUNTER_0_1;
    protected int missed;
    protected int covered;

    static {
        int i = 0;
        while (i <= 30) {
            CounterImpl.SINGLETONS[i] = new CounterImpl[31];
            int j = 0;
            while (j <= 30) {
                CounterImpl.SINGLETONS[i][j] = new Fix(i, j);
                ++j;
            }
            ++i;
        }
        COUNTER_0_0 = SINGLETONS[0][0];
        COUNTER_1_0 = SINGLETONS[1][0];
        COUNTER_0_1 = SINGLETONS[0][1];
    }

    public static CounterImpl getInstance(int missed, int covered) {
        if (missed <= 30 && covered <= 30) {
            return SINGLETONS[missed][covered];
        }
        return new Var(missed, covered);
    }

    public static CounterImpl getInstance(ICounter counter) {
        return CounterImpl.getInstance(counter.getMissedCount(), counter.getCoveredCount());
    }

    protected CounterImpl(int missed, int covered) {
        this.missed = missed;
        this.covered = covered;
    }

    public CounterImpl increment(ICounter counter) {
        return this.increment(counter.getMissedCount(), counter.getCoveredCount());
    }

    public abstract CounterImpl increment(int var1, int var2);

    public int getTotalCount() {
        return this.missed + this.covered;
    }

    public int getCoveredCount() {
        return this.covered;
    }

    public int getMissedCount() {
        return this.missed;
    }

    public double getCoveredRatio() {
        return (double)this.covered / (double)(this.missed + this.covered);
    }

    public double getMissedRatio() {
        return (double)this.missed / (double)(this.missed + this.covered);
    }

    public int getStatus() {
        int status;
        int n = status = this.covered > 0 ? 2 : 0;
        if (this.missed > 0) {
            status |= 1;
        }
        return status;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ICounter) {
            ICounter that = (ICounter)obj;
            return this.missed == that.getMissedCount() && this.covered == that.getCoveredCount();
        }
        return false;
    }

    public int hashCode() {
        return this.missed ^ this.covered * 17;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Counter[");
        b.append(this.getMissedCount());
        b.append('/').append(this.getCoveredCount());
        b.append(']');
        return b.toString();
    }

    private static class Fix
    extends CounterImpl {
        public Fix(int missed, int covered) {
            super(missed, covered);
        }

        public CounterImpl increment(int missed, int covered) {
            return Fix.getInstance(this.missed + missed, this.covered + covered);
        }
    }

    private static class Var
    extends CounterImpl {
        public Var(int missed, int covered) {
            super(missed, covered);
        }

        public CounterImpl increment(int missed, int covered) {
            this.missed += missed;
            this.covered += covered;
            return this;
        }
    }
}

