/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.flow;

import org.jacoco.core.internal.flow.LabelInfo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public final class LabelFlowAnalyzer
implements MethodVisitor {
    boolean successor = false;
    boolean first = true;

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        LabelInfo.setTarget(start);
        LabelInfo.setTarget(handler);
    }

    public void visitJumpInsn(int opcode, Label label) {
        LabelInfo.setTarget(label);
        if (opcode == 168) {
            throw new AssertionError((Object)"Subroutines not supported.");
        }
        this.successor = opcode != 167;
        this.first = false;
    }

    public void visitLabel(Label label) {
        if (this.first) {
            LabelInfo.setTarget(label);
        }
        if (this.successor) {
            LabelInfo.setSuccessor(label);
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.visitSwitchInsn(dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.visitSwitchInsn(dflt, labels);
    }

    private void visitSwitchInsn(Label dflt, Label[] labels) {
        LabelInfo.resetDone(dflt);
        LabelInfo.resetDone(labels);
        LabelFlowAnalyzer.setTargetIfNotDone(dflt);
        Label[] labelArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            Label l = labelArray[n2];
            LabelFlowAnalyzer.setTargetIfNotDone(l);
            ++n2;
        }
        this.successor = false;
        this.first = false;
    }

    private static void setTargetIfNotDone(Label label) {
        if (!LabelInfo.isDone(label)) {
            LabelInfo.setTarget(label);
            LabelInfo.setDone(label);
        }
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 169: {
                throw new AssertionError((Object)"Subroutines not supported.");
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                this.successor = false;
                break;
            }
            default: {
                this.successor = true;
            }
        }
        this.first = false;
    }

    public void visitIntInsn(int opcode, int operand) {
        this.successor = true;
        this.first = false;
    }

    public void visitVarInsn(int opcode, int var) {
        this.successor = true;
        this.first = false;
    }

    public void visitTypeInsn(int opcode, String type) {
        this.successor = true;
        this.first = false;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.successor = true;
        this.first = false;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.successor = true;
        this.first = false;
    }

    public void visitLdcInsn(Object cst) {
        this.successor = true;
        this.first = false;
    }

    public void visitIincInsn(int var, int increment) {
        this.successor = true;
        this.first = false;
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.successor = true;
        this.first = false;
    }

    public void visitAttribute(Attribute attr) {
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return null;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return null;
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    public void visitCode() {
    }

    public void visitLineNumber(int line, Label start) {
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    public void visitMaxs(int maxStack, int maxLocals) {
    }

    public void visitEnd() {
    }
}

