/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.runtime;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jacoco.core.runtime.AbstractRuntime;
import org.jacoco.core.runtime.ExecutionDataAccess;
import org.objectweb.asm.MethodVisitor;

public class LoggerRuntime
extends AbstractRuntime {
    private static final String CHANNEL = "jacoco-runtime";
    private final String key = Integer.toHexString(this.hashCode());
    private final Logger logger = this.configureLogger();
    private final Handler handler = new RuntimeHandler();

    private Logger configureLogger() {
        Logger l = Logger.getLogger(CHANNEL);
        l.setUseParentHandlers(false);
        l.setLevel(Level.ALL);
        return l;
    }

    public int generateDataAccessor(long classid, String classname, int probecount, MethodVisitor mv) {
        ExecutionDataAccess.generateArgumentArray(classid, classname, probecount, mv);
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)CHANNEL);
        mv.visitMethodInsn(184, "java/util/logging/Logger", "getLogger", "(Ljava/lang/String;)Ljava/util/logging/Logger;");
        mv.visitInsn(95);
        mv.visitFieldInsn(178, "java/util/logging/Level", "INFO", "Ljava/util/logging/Level;");
        mv.visitInsn(95);
        mv.visitLdcInsn((Object)this.key);
        mv.visitInsn(95);
        mv.visitMethodInsn(182, "java/util/logging/Logger", "log", "(Ljava/util/logging/Level;Ljava/lang/String;[Ljava/lang/Object;)V");
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, "[Z");
        return 5;
    }

    public void startup() {
        this.setStartTimeStamp();
        this.logger.addHandler(this.handler);
    }

    public void shutdown() {
        this.logger.removeHandler(this.handler);
    }

    private class RuntimeHandler
    extends Handler {
        private RuntimeHandler() {
        }

        public void publish(LogRecord record) {
            if (LoggerRuntime.this.key.equals(record.getMessage())) {
                LoggerRuntime.this.access.getExecutionData(record.getParameters());
            }
        }

        public void flush() {
        }

        public void close() throws SecurityException {
            LoggerRuntime.this.logger.addHandler(LoggerRuntime.this.handler);
        }
    }
}

