/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.internal.analysis.CounterImpl;

public abstract class LineImpl
implements ILine {
    private static final int SINGLETON_INS_LIMIT = 8;
    private static final int SINGLETON_BRA_LIMIT = 4;
    private static final LineImpl[][][][] SINGLETONS = new LineImpl[9][][][];
    public static final LineImpl EMPTY;
    protected CounterImpl instructions;
    protected CounterImpl branches;

    static {
        int i = 0;
        while (i <= 8) {
            LineImpl.SINGLETONS[i] = new LineImpl[9][][];
            int j = 0;
            while (j <= 8) {
                LineImpl.SINGLETONS[i][j] = new LineImpl[5][];
                int k = 0;
                while (k <= 4) {
                    LineImpl.SINGLETONS[i][j][k] = new LineImpl[5];
                    int l = 0;
                    while (l <= 4) {
                        LineImpl.SINGLETONS[i][j][k][l] = new Fix(i, j, k, l);
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        EMPTY = SINGLETONS[0][0][0][0];
    }

    private static LineImpl getInstance(CounterImpl instructions, CounterImpl branches) {
        int im = instructions.getMissedCount();
        int ic = instructions.getCoveredCount();
        int bm = branches.getMissedCount();
        int bc = branches.getCoveredCount();
        if (im <= 8 && ic <= 8 && bm <= 4 && bc <= 4) {
            return SINGLETONS[im][ic][bm][bc];
        }
        return new Var(instructions, branches);
    }

    private LineImpl(CounterImpl instructions, CounterImpl branches) {
        this.instructions = instructions;
        this.branches = branches;
    }

    public abstract LineImpl increment(ICounter var1, ICounter var2);

    public int getStatus() {
        return this.instructions.getStatus() | this.branches.getStatus();
    }

    public ICounter getInstructionCounter() {
        return this.instructions;
    }

    public ICounter getBranchCounter() {
        return this.branches;
    }

    public int hashCode() {
        return 23 * this.instructions.hashCode() ^ this.branches.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ILine) {
            ILine that = (ILine)obj;
            return this.instructions.equals(that.getInstructionCounter()) && this.branches.equals(that.getBranchCounter());
        }
        return false;
    }

    /* synthetic */ LineImpl(CounterImpl counterImpl, CounterImpl counterImpl2, LineImpl lineImpl) {
        this(counterImpl, counterImpl2);
    }

    private static final class Fix
    extends LineImpl {
        public Fix(int im, int ic, int bm, int bc) {
            super(CounterImpl.getInstance(im, ic), CounterImpl.getInstance(bm, bc), null);
        }

        public LineImpl increment(ICounter instructions, ICounter branches) {
            return LineImpl.getInstance(this.instructions.increment(instructions), this.branches.increment(branches));
        }
    }

    private static final class Var
    extends LineImpl {
        Var(CounterImpl instructions, CounterImpl branches) {
            super(instructions, branches, null);
        }

        public LineImpl increment(ICounter instructions, ICounter branches) {
            this.instructions = this.instructions.increment(instructions);
            this.branches = this.branches.increment(branches);
            return this;
        }
    }
}

