/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.flow;

import org.jacoco.core.internal.flow.ClassProbesVisitor;
import org.jacoco.core.internal.flow.IProbeIdGenerator;
import org.jacoco.core.internal.flow.LabelFlowAnalyzer;
import org.jacoco.core.internal.flow.MethodProbesAdapter;
import org.jacoco.core.internal.flow.MethodProbesVisitor;
import org.jacoco.core.internal.flow.MethodSanitizer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;

public class ClassProbesAdapter
extends ClassVisitor
implements IProbeIdGenerator {
    private static final MethodProbesVisitor EMPTY_METHOD_PROBES_VISITOR;
    private final ClassProbesVisitor cv;
    private int counter = 0;
    private boolean interfaceType;

    static {
        class Impl
        extends MethodProbesVisitor {
            Impl() {
            }

            public void visitProbe(int probeId) {
            }

            public void visitJumpInsnWithProbe(int opcode, Label label, int probeId) {
            }

            public void visitInsnWithProbe(int opcode, int probeId) {
            }

            public void visitTableSwitchInsnWithProbes(int min, int max, Label dflt, Label[] labels) {
            }

            public void visitLookupSwitchInsnWithProbes(Label dflt, int[] keys, Label[] labels) {
            }
        }
        EMPTY_METHOD_PROBES_VISITOR = new Impl();
    }

    public ClassProbesAdapter(ClassProbesVisitor cv) {
        super(262144, (ClassVisitor)cv);
        this.cv = cv;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.interfaceType = (access & 0x200) != 0;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public final MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodProbesVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        final MethodProbesVisitor methodProbes = mv == null ? EMPTY_METHOD_PROBES_VISITOR : mv;
        return new MethodSanitizer(null, access, name, desc, signature, exceptions){

            public void visitEnd() {
                super.visitEnd();
                LabelFlowAnalyzer.markLabels((MethodNode)this);
                if (ClassProbesAdapter.this.interfaceType) {
                    ProbeCounter probeCounter = new ProbeCounter();
                    MethodProbesAdapter adapter = new MethodProbesAdapter(EMPTY_METHOD_PROBES_VISITOR, probeCounter);
                    this.instructions.accept((MethodVisitor)adapter);
                    ClassProbesAdapter.this.cv.visitTotalProbeCount(probeCounter.count);
                }
                this.accept(new MethodProbesAdapter(methodProbes, ClassProbesAdapter.this));
            }
        };
    }

    public void visitEnd() {
        if (!this.interfaceType) {
            this.cv.visitTotalProbeCount(this.counter);
        }
        super.visitEnd();
    }

    public int nextId() {
        return this.counter++;
    }

    private static class ProbeCounter
    implements IProbeIdGenerator {
        int count = 0;

        private ProbeCounter() {
        }

        public int nextId() {
            return this.count++;
        }
    }
}

