/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.analysis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.internal.analysis.ClassAnalyzer;
import org.jacoco.core.internal.analysis.ContentTypeDetector;
import org.jacoco.core.internal.analysis.StringPool;
import org.jacoco.core.internal.data.CRC64;
import org.jacoco.core.internal.flow.ClassProbesAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class Analyzer {
    private final ExecutionDataStore executionData;
    private final ICoverageVisitor coverageVisitor;
    private final StringPool stringPool;

    public Analyzer(ExecutionDataStore executionData, ICoverageVisitor coverageVisitor) {
        this.executionData = executionData;
        this.coverageVisitor = coverageVisitor;
        this.stringPool = new StringPool();
    }

    private ClassVisitor createAnalyzingVisitor(long classid) {
        ExecutionData data = this.executionData.get(classid);
        boolean[] classExec = data == null ? null : data.getData();
        ClassAnalyzer analyzer = new ClassAnalyzer(classid, classExec, this.stringPool){

            public void visitEnd() {
                super.visitEnd();
                Analyzer.this.coverageVisitor.visitCoverage(this.getCoverage());
            }
        };
        return new ClassProbesAdapter(analyzer);
    }

    public void analyzeClass(ClassReader reader) {
        ClassVisitor visitor = this.createAnalyzingVisitor(CRC64.checksum(reader.b));
        reader.accept(visitor, 0);
    }

    public void analyzeClass(byte[] buffer) {
        this.analyzeClass(new ClassReader(buffer));
    }

    public void analyzeClass(InputStream input) throws IOException {
        this.analyzeClass(new ClassReader(input));
    }

    public int analyzeArchive(InputStream input) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(input);
        int count = 0;
        while ((entry = zip.getNextEntry()) != null) {
            count += this.analyzeAll(zip);
        }
        return count;
    }

    public int analyzeAll(InputStream input) throws IOException {
        ContentTypeDetector detector = new ContentTypeDetector(input);
        switch (detector.getType()) {
            case -889275714: {
                this.analyzeClass(detector.getInputStream());
                return 1;
            }
            case 1347093252: {
                return this.analyzeArchive(detector.getInputStream());
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int analyzeAll(File file) throws IOException {
        int count = 0;
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                count += this.analyzeAll(f);
            }
        } else {
            FileInputStream in = new FileInputStream(file);
            try {
                count += this.analyzeAll(in);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        return count;
    }

    public int analyzeAll(String path, File basedir) throws IOException {
        int count = 0;
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreTokens()) {
            count += this.analyzeAll(new File(basedir, st.nextToken()));
        }
        return count;
    }
}

