/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.instr;

import org.jacoco.core.internal.instr.IProbeArrayStrategy;
import org.jacoco.core.internal.instr.IProbeInserter;
import org.jacoco.core.internal.instr.InstrSupport;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

class ProbeInserter
extends MethodVisitor
implements IProbeInserter {
    private final IProbeArrayStrategy arrayStrategy;
    private final int variable;
    private final int variableIdx;
    private int accessorStackSize;

    ProbeInserter(int access, String desc, MethodVisitor mv, IProbeArrayStrategy arrayStrategy) {
        super(262144, mv);
        int idx;
        this.arrayStrategy = arrayStrategy;
        int pos = idx = (8 & access) == 0 ? 1 : 0;
        for (Type t : Type.getArgumentTypes((String)desc)) {
            ++idx;
            pos += t.getSize();
        }
        this.variableIdx = idx;
        this.variable = pos;
    }

    public void insertProbe(int id) {
        this.mv.visitVarInsn(25, this.variable);
        InstrSupport.push(this.mv, id);
        this.mv.visitInsn(4);
        this.mv.visitInsn(84);
    }

    public void visitCode() {
        this.accessorStackSize = this.arrayStrategy.storeInstance(this.mv, this.variable);
        this.mv.visitCode();
    }

    public final void visitVarInsn(int opcode, int var) {
        this.mv.visitVarInsn(opcode, this.map(var));
    }

    public final void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(this.map(var), increment);
    }

    public final void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.mv.visitLocalVariable(name, desc, signature, start, end, this.map(index));
    }

    public final void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        int increasedStack = Math.max(maxStack + 3, this.accessorStackSize);
        this.mv.visitMaxs(increasedStack, maxLocals + 1);
    }

    private int map(int var) {
        if (var < this.variable) {
            return var;
        }
        return var + 1;
    }

    public final void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (type != -1) {
            throw new IllegalArgumentException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        int n = Math.max(nLocal, this.variableIdx) + 1;
        Object[] newLocal = new Object[n];
        for (int i = 0; i < n; ++i) {
            newLocal[i] = i < this.variableIdx ? (i < nLocal ? local[i] : Opcodes.TOP) : (i > this.variableIdx ? local[i - 1] : "[Z");
        }
        this.mv.visitFrame(type, n, newLocal, nStack, stack);
    }
}

