/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.runtime;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class AgentOptions {
    public static final String DESTFILE = "destfile";
    public static final String APPEND = "append";
    public static final String INCLUDES = "includes";
    public static final String EXCLUDES = "excludes";
    public static final String EXCLCLASSLOADER = "exclclassloader";
    public static final String SESSIONID = "sessionid";
    public static final String DUMPONEXIT = "dumponexit";
    public static final String OUTPUT = "output";
    public static final String ADDRESS = "address";
    public static final String DEFAULT_ADDRESS = null;
    public static final String PORT = "port";
    public static final int DEFAULT_PORT = 6300;
    public static final String CLASSDUMPDIR = "classdumpdir";
    private static final Collection<String> VALID_OPTIONS = Arrays.asList("destfile", "append", "includes", "excludes", "exclclassloader", "sessionid", "dumponexit", "output", "address", "port", "classdumpdir");
    private final Map<String, String> options = new HashMap<String, String>();

    public AgentOptions() {
    }

    public AgentOptions(String optionstr) {
        this();
        if (optionstr != null && optionstr.length() > 0) {
            for (String entry : optionstr.split(",")) {
                int pos = entry.indexOf(61);
                if (pos == -1) {
                    throw new IllegalArgumentException(String.format("Invalid agent option syntax \"%s\".", optionstr));
                }
                String key = entry.substring(0, pos);
                if (!VALID_OPTIONS.contains(key)) {
                    throw new IllegalArgumentException(String.format("Unknown agent option \"%s\".", key));
                }
                String value = entry.substring(pos + 1);
                this.setOption(key, value);
            }
            this.validateAll();
        }
    }

    private void validateAll() {
        this.validatePort(this.getPort());
        this.getOutput();
    }

    private void validatePort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException("port must be positive");
        }
    }

    public String getDestfile() {
        return this.getOption(DESTFILE, "jacoco.exec");
    }

    public void setDestfile(String destfile) {
        this.setOption(DESTFILE, destfile);
    }

    public boolean getAppend() {
        return this.getOption(APPEND, true);
    }

    public void setAppend(boolean append) {
        this.setOption(APPEND, append);
    }

    public String getIncludes() {
        return this.getOption(INCLUDES, "*");
    }

    public void setIncludes(String includes) {
        this.setOption(INCLUDES, includes);
    }

    public String getExcludes() {
        return this.getOption(EXCLUDES, "");
    }

    public void setExcludes(String excludes) {
        this.setOption(EXCLUDES, excludes);
    }

    public String getExclClassloader() {
        return this.getOption(EXCLCLASSLOADER, "sun.reflect.DelegatingClassLoader");
    }

    public void setExclClassloader(String expression) {
        this.setOption(EXCLCLASSLOADER, expression);
    }

    public String getSessionId() {
        return this.getOption(SESSIONID, null);
    }

    public void setSessionId(String id) {
        this.setOption(SESSIONID, id);
    }

    public boolean getDumpOnExit() {
        return this.getOption(DUMPONEXIT, true);
    }

    public void setDumpOnExit(boolean dumpOnExit) {
        this.setOption(DUMPONEXIT, dumpOnExit);
    }

    public int getPort() {
        return this.getOption(PORT, 6300);
    }

    public void setPort(int port) {
        this.validatePort(port);
        this.setOption(PORT, port);
    }

    public String getAddress() {
        return this.getOption(ADDRESS, DEFAULT_ADDRESS);
    }

    public void setAddress(String address) {
        this.setOption(ADDRESS, address);
    }

    public OutputMode getOutput() {
        String value = this.options.get(OUTPUT);
        return value == null ? OutputMode.file : OutputMode.valueOf(value);
    }

    public void setOutput(String output) {
        this.setOutput(OutputMode.valueOf(output));
    }

    public void setOutput(OutputMode output) {
        this.setOption(OUTPUT, output.name());
    }

    public String getClassDumpDir() {
        return this.getOption(CLASSDUMPDIR, null);
    }

    public void setClassDumpDir(String location) {
        this.setOption(CLASSDUMPDIR, location);
    }

    private void setOption(String key, int value) {
        this.setOption(key, Integer.toString(value));
    }

    private void setOption(String key, boolean value) {
        this.setOption(key, Boolean.toString(value));
    }

    private void setOption(String key, String value) {
        if (value.contains(",")) {
            throw new IllegalArgumentException(String.format("Invalid character in option argument \"%s\"", value));
        }
        this.options.put(key, value);
    }

    private String getOption(String key, String defaultValue) {
        String value = this.options.get(key);
        return value == null ? defaultValue : value;
    }

    private boolean getOption(String key, boolean defaultValue) {
        String value = this.options.get(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    private int getOption(String key, int defaultValue) {
        String value = this.options.get(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public String getVMArgument(File agentJarFile) {
        return String.format("-javaagent:%s=%s", agentJarFile, this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String key : VALID_OPTIONS) {
            String value = this.options.get(key);
            if (value == null) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(key).append('=').append(value);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputMode {
        file,
        tcpserver,
        tcpclient,
        mbean;

    }
}

