/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.instr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jacoco.core.internal.ContentTypeDetector;
import org.jacoco.core.internal.data.CRC64;
import org.jacoco.core.internal.flow.ClassProbesAdapter;
import org.jacoco.core.internal.instr.ClassInstrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class Instrumenter {
    private final IExecutionDataAccessorGenerator accessGenerator;

    public Instrumenter(IExecutionDataAccessorGenerator runtime) {
        this.accessGenerator = runtime;
    }

    private ClassVisitor createInstrumentingVisitor(long classid, ClassVisitor cv) {
        return new ClassProbesAdapter(new ClassInstrumenter(classid, this.accessGenerator, cv));
    }

    public byte[] instrument(ClassReader reader) {
        ClassWriter writer = new ClassWriter(reader, 0);
        ClassVisitor visitor = this.createInstrumentingVisitor(CRC64.checksum(reader.b), (ClassVisitor)writer);
        reader.accept(visitor, 8);
        return writer.toByteArray();
    }

    public byte[] instrument(byte[] buffer) {
        return this.instrument(new ClassReader(buffer));
    }

    public byte[] instrument(InputStream input) throws IOException {
        return this.instrument(new ClassReader(input));
    }

    public void instrument(InputStream input, OutputStream output) throws IOException {
        output.write(this.instrument(new ClassReader(input)));
    }

    public int instrumentArchive(InputStream input, OutputStream output) throws IOException {
        ZipEntry entry;
        ZipInputStream zipin = new ZipInputStream(input);
        ZipOutputStream zipout = new ZipOutputStream(output);
        int count = 0;
        while ((entry = zipin.getNextEntry()) != null) {
            zipout.putNextEntry(new ZipEntry(entry.getName()));
            count += this.instrumentAll(zipin, zipout);
            zipout.closeEntry();
        }
        zipout.finish();
        return count;
    }

    public int instrumentAll(InputStream input, OutputStream output) throws IOException {
        int len;
        ContentTypeDetector detector = new ContentTypeDetector(input);
        switch (detector.getType()) {
            case -889275714: {
                this.instrument(detector.getInputStream(), output);
                return 1;
            }
            case 1347093252: {
                return this.instrumentArchive(detector.getInputStream(), output);
            }
        }
        byte[] buffer = new byte[1024];
        while ((len = detector.getInputStream().read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
        return 0;
    }
}

