/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.instr;

import org.jacoco.core.internal.instr.IFrameInserter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

class FrameTracker
extends MethodVisitor
implements IFrameInserter {
    private final String owner;
    private Object[] local;
    private int localSize;
    private Object[] stack;
    private int stackSize;

    public FrameTracker(String owner, int access, String name, String desc, MethodVisitor mv) {
        super(262144, mv);
        this.owner = owner;
        this.local = new Object[8];
        this.localSize = 0;
        this.stack = new Object[8];
        this.stackSize = 0;
        if ((access & 8) == 0) {
            if ("<init>".equals(name)) {
                this.set(this.localSize, Opcodes.UNINITIALIZED_THIS);
            } else {
                this.set(this.localSize, owner);
            }
        }
        for (Type t : Type.getArgumentTypes((String)desc)) {
            this.set(this.localSize, t);
        }
    }

    public void insertFrame() {
        Object[] local = new Object[this.localSize];
        Object[] stack = new Object[this.stackSize];
        int localSize = this.reduce(this.local, this.localSize, local);
        int stackSize = this.reduce(this.stack, this.stackSize, stack);
        this.mv.visitFrame(-1, localSize, local, stackSize, stack);
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (type != -1) {
            throw new IllegalArgumentException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        this.local = this.ensureSize(this.local, nLocal * 2);
        this.stack = this.ensureSize(this.stack, nStack * 2);
        this.localSize = this.expand(local, nLocal, this.local);
        this.stackSize = this.expand(stack, nStack, this.stack);
        this.mv.visitFrame(type, nLocal, local, nStack, stack);
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 0: 
            case 177: {
                break;
            }
            case 87: 
            case 172: 
            case 174: 
            case 176: 
            case 191: 
            case 194: 
            case 195: {
                this.pop(1);
                break;
            }
            case 88: 
            case 173: 
            case 175: {
                this.pop(2);
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.pop(3);
                break;
            }
            case 80: 
            case 82: {
                this.pop(4);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.push(Opcodes.INTEGER);
                break;
            }
            case 116: 
            case 139: 
            case 145: 
            case 146: 
            case 147: 
            case 190: {
                this.pop(1);
                this.push(Opcodes.INTEGER);
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 136: 
            case 142: 
            case 149: 
            case 150: {
                this.pop(2);
                this.push(Opcodes.INTEGER);
                break;
            }
            case 148: 
            case 151: 
            case 152: {
                this.pop(4);
                this.push(Opcodes.INTEGER);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.push(Opcodes.FLOAT);
                break;
            }
            case 118: 
            case 134: {
                this.pop(1);
                this.push(Opcodes.FLOAT);
                break;
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 137: 
            case 144: {
                this.pop(2);
                this.push(Opcodes.FLOAT);
                break;
            }
            case 9: 
            case 10: {
                this.push(Opcodes.LONG);
                this.push(Opcodes.TOP);
                break;
            }
            case 133: 
            case 140: {
                this.pop(1);
                this.push(Opcodes.LONG);
                this.push(Opcodes.TOP);
                break;
            }
            case 47: 
            case 117: 
            case 143: {
                this.pop(2);
                this.push(Opcodes.LONG);
                this.push(Opcodes.TOP);
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                this.pop(3);
                this.push(Opcodes.LONG);
                this.push(Opcodes.TOP);
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.pop(4);
                this.push(Opcodes.LONG);
                this.push(Opcodes.TOP);
                break;
            }
            case 14: 
            case 15: {
                this.push(Opcodes.DOUBLE);
                this.push(Opcodes.TOP);
                break;
            }
            case 135: 
            case 141: {
                this.pop(1);
                this.push(Opcodes.DOUBLE);
                this.push(Opcodes.TOP);
                break;
            }
            case 49: 
            case 119: 
            case 138: {
                this.pop(2);
                this.push(Opcodes.DOUBLE);
                this.push(Opcodes.TOP);
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.pop(4);
                this.push(Opcodes.DOUBLE);
                this.push(Opcodes.TOP);
                break;
            }
            case 1: {
                this.push(Opcodes.NULL);
                break;
            }
            case 50: {
                this.pop(1);
                Object t1 = this.pop();
                this.push(Type.getType((String)((String)t1).substring(1)));
                break;
            }
            case 89: {
                Object t1 = this.pop();
                this.push(t1);
                this.push(t1);
                break;
            }
            case 90: {
                Object t1 = this.pop();
                Object t2 = this.pop();
                this.push(t1);
                this.push(t2);
                this.push(t1);
                break;
            }
            case 91: {
                Object t1 = this.pop();
                Object t2 = this.pop();
                Object t3 = this.pop();
                this.push(t1);
                this.push(t3);
                this.push(t2);
                this.push(t1);
                break;
            }
            case 92: {
                Object t1 = this.pop();
                Object t2 = this.pop();
                this.push(t2);
                this.push(t1);
                this.push(t2);
                this.push(t1);
                break;
            }
            case 93: {
                Object t1 = this.pop();
                Object t2 = this.pop();
                Object t3 = this.pop();
                this.push(t2);
                this.push(t1);
                this.push(t3);
                this.push(t2);
                this.push(t1);
                break;
            }
            case 94: {
                Object t1 = this.pop();
                Object t2 = this.pop();
                Object t3 = this.pop();
                Object t4 = this.pop();
                this.push(t2);
                this.push(t1);
                this.push(t4);
                this.push(t3);
                this.push(t2);
                this.push(t1);
                break;
            }
            case 95: {
                Object t1 = this.pop();
                Object t2 = this.pop();
                this.push(t1);
                this.push(t2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.mv.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        block0 : switch (opcode) {
            case 16: 
            case 17: {
                this.push(Opcodes.INTEGER);
                break;
            }
            case 188: {
                this.pop(1);
                switch (operand) {
                    case 4: {
                        this.push("[Z");
                        break block0;
                    }
                    case 5: {
                        this.push("[C");
                        break block0;
                    }
                    case 6: {
                        this.push("[F");
                        break block0;
                    }
                    case 7: {
                        this.push("[D");
                        break block0;
                    }
                    case 8: {
                        this.push("[B");
                        break block0;
                    }
                    case 9: {
                        this.push("[S");
                        break block0;
                    }
                    case 10: {
                        this.push("[I");
                        break block0;
                    }
                    case 11: {
                        this.push("[J");
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.mv.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        switch (opcode) {
            case 25: {
                this.push(this.get(var));
                break;
            }
            case 21: {
                this.push(Opcodes.INTEGER);
                break;
            }
            case 23: {
                this.push(Opcodes.FLOAT);
                break;
            }
            case 22: {
                this.push(Opcodes.LONG);
                this.push(Opcodes.TOP);
                break;
            }
            case 24: {
                this.push(Opcodes.DOUBLE);
                this.push(Opcodes.TOP);
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                Object t = this.pop();
                this.set(var, t);
                break;
            }
            case 55: 
            case 57: {
                this.pop(1);
                Object t = this.pop();
                this.set(var, t);
                this.set(var + 1, Opcodes.TOP);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.mv.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String type) {
        switch (opcode) {
            case 187: {
                Label label = new Label();
                this.mv.visitLabel(label);
                this.push(label);
                break;
            }
            case 189: {
                this.pop(1);
                this.push('[' + Type.getObjectType((String)type).getDescriptor());
                break;
            }
            case 192: {
                this.pop(1);
                this.push(type);
                break;
            }
            case 193: {
                this.pop(1);
                this.push(Opcodes.INTEGER);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.mv.visitTypeInsn(opcode, type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        Type t = Type.getType((String)desc);
        switch (opcode) {
            case 179: {
                this.pop(t);
                break;
            }
            case 181: {
                this.pop(t);
                this.pop(1);
                break;
            }
            case 178: {
                this.push(t);
                break;
            }
            case 180: {
                this.pop(1);
                this.push(t);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        for (Type t : Type.getArgumentTypes((String)desc)) {
            this.pop(t);
        }
        if (opcode != 184) {
            Object target = this.pop();
            if (target == Opcodes.UNINITIALIZED_THIS) {
                this.replace(Opcodes.UNINITIALIZED_THIS, this.owner);
            } else if (target instanceof Label) {
                this.replace(target, owner);
            }
        }
        this.push(Type.getReturnType((String)desc));
        this.mv.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        for (Type t : Type.getArgumentTypes((String)desc)) {
            this.pop(t);
        }
        this.push(Type.getReturnType((String)desc));
        this.mv.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    public void visitLdcInsn(Object cst) {
        if (cst instanceof Integer) {
            this.push(Opcodes.INTEGER);
        } else if (cst instanceof Float) {
            this.push(Opcodes.FLOAT);
        } else if (cst instanceof Long) {
            this.push(Opcodes.LONG);
            this.push(Opcodes.TOP);
        } else if (cst instanceof Double) {
            this.push(Opcodes.DOUBLE);
            this.push(Opcodes.TOP);
        } else if (cst instanceof String) {
            this.push("java/lang/String");
        } else if (cst instanceof Type) {
            this.push("java/lang/Class");
        } else {
            throw new IllegalArgumentException();
        }
        this.mv.visitLdcInsn(cst);
    }

    public void visitJumpInsn(int opcode, Label label) {
        switch (opcode) {
            case 167: {
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.pop(1);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.pop(2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.mv.visitJumpInsn(opcode, label);
    }

    public void visitIincInsn(int var, int increment) {
        this.set(var, Opcodes.INTEGER);
        this.mv.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.pop(1);
        this.mv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.pop(1);
        this.mv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.pop(dims);
        this.push(desc);
        this.mv.visitMultiANewArrayInsn(desc, dims);
    }

    private void push(Object type) {
        this.stack = this.ensureSize(this.stack, this.stackSize + 1);
        this.stack[this.stackSize] = type;
        ++this.stackSize;
    }

    private void push(Type type) {
        switch (type.getSort()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.push(Opcodes.INTEGER);
                break;
            }
            case 6: {
                this.push(Opcodes.FLOAT);
                break;
            }
            case 7: {
                this.push(Opcodes.LONG);
                this.push(Opcodes.TOP);
                break;
            }
            case 8: {
                this.push(Opcodes.DOUBLE);
                this.push(Opcodes.TOP);
                break;
            }
            case 9: 
            case 10: {
                this.push(type.getInternalName());
                break;
            }
            default: {
                throw new AssertionError(type);
            }
        }
    }

    private Object pop() {
        --this.stackSize;
        this.assertValidFrames(this.stackSize);
        return this.stack[this.stackSize];
    }

    private void pop(int count) {
        this.stackSize -= count;
        this.assertValidFrames(this.stackSize);
    }

    private void assertValidFrames(int stackSize) {
        if (stackSize < 0) {
            throw new IllegalStateException("Missing or invalid stackmap frames.");
        }
    }

    private void pop(Type type) {
        this.pop(type.getSize());
    }

    private void set(int pos, Object type) {
        this.local = this.ensureSize(this.local, pos + 1);
        for (int i = this.localSize; i < pos; ++i) {
            this.local[i] = Opcodes.TOP;
        }
        this.localSize = Math.max(this.localSize, pos + 1);
        this.local[pos] = type;
    }

    private void set(int pos, Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.set(pos, Opcodes.INTEGER);
                break;
            }
            case 6: {
                this.set(pos, Opcodes.FLOAT);
                break;
            }
            case 7: {
                this.set(pos, Opcodes.LONG);
                this.set(pos + 1, Opcodes.TOP);
                break;
            }
            case 8: {
                this.set(pos, Opcodes.DOUBLE);
                this.set(pos + 1, Opcodes.TOP);
                break;
            }
            case 9: 
            case 10: {
                this.set(pos, type.getInternalName());
                break;
            }
            default: {
                throw new AssertionError(type);
            }
        }
    }

    private Object get(int pos) {
        if (this.localSize <= pos) {
            throw new IllegalStateException("Missing or invalid stackmap frames.");
        }
        return this.local[pos];
    }

    private Object[] ensureSize(Object[] array, int size) {
        int newLength;
        if (array.length >= size) {
            return array;
        }
        for (newLength = array.length; newLength < size; newLength *= 2) {
        }
        Object[] newArray = new Object[newLength];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    private int expand(Object[] source, int size, Object[] target) {
        int targetIdx = 0;
        for (int sourceIdx = 0; sourceIdx < size; ++sourceIdx) {
            Object type = source[sourceIdx];
            target[targetIdx++] = type;
            if (type != Opcodes.LONG && type != Opcodes.DOUBLE) continue;
            target[targetIdx++] = Opcodes.TOP;
        }
        return targetIdx;
    }

    private int reduce(Object[] source, int size, Object[] target) {
        int targetIdx = 0;
        for (int sourceIdx = 0; sourceIdx < size; ++sourceIdx) {
            Object type = source[sourceIdx];
            target[targetIdx++] = type;
            if (type != Opcodes.LONG && type != Opcodes.DOUBLE) continue;
            ++sourceIdx;
        }
        return targetIdx;
    }

    private void replace(Object oldtype, Object newtype) {
        int i;
        for (i = 0; i < this.localSize; ++i) {
            if (!oldtype.equals(this.local[i])) continue;
            this.local[i] = newtype;
        }
        for (i = 0; i < this.stackSize; ++i) {
            if (!oldtype.equals(this.stack[i])) continue;
            this.stack[i] = newtype;
        }
    }
}

