/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.attribute;

import com.google.common.base.Preconditions;
import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.graphdb.query.JanusGraphPredicate;

public enum Geo implements JanusGraphPredicate
{
    INTERSECT{

        @Override
        public boolean test(Object value, Object condition) {
            Preconditions.checkArgument((boolean)(condition instanceof Geoshape));
            if (value == null) {
                return false;
            }
            Preconditions.checkArgument((boolean)(value instanceof Geoshape));
            return ((Geoshape)value).intersect((Geoshape)condition);
        }

        public String toString() {
            return "intersect";
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return DISJOINT;
        }
    }
    ,
    DISJOINT{

        @Override
        public boolean test(Object value, Object condition) {
            Preconditions.checkArgument((boolean)(condition instanceof Geoshape));
            if (value == null) {
                return false;
            }
            Preconditions.checkArgument((boolean)(value instanceof Geoshape));
            return ((Geoshape)value).disjoint((Geoshape)condition);
        }

        public String toString() {
            return "disjoint";
        }

        @Override
        public boolean hasNegation() {
            return true;
        }

        @Override
        public JanusGraphPredicate negate() {
            return INTERSECT;
        }
    }
    ,
    WITHIN{

        @Override
        public boolean test(Object value, Object condition) {
            Preconditions.checkArgument((boolean)(condition instanceof Geoshape));
            if (value == null) {
                return false;
            }
            Preconditions.checkArgument((boolean)(value instanceof Geoshape));
            return ((Geoshape)value).within((Geoshape)condition);
        }

        public String toString() {
            return "within";
        }

        @Override
        public boolean hasNegation() {
            return false;
        }

        @Override
        public JanusGraphPredicate negate() {
            throw new UnsupportedOperationException();
        }
    };


    @Override
    public boolean isValidCondition(Object condition) {
        return condition != null && condition instanceof Geoshape;
    }

    @Override
    public boolean isValidValueType(Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        return clazz.equals(Geoshape.class);
    }

    @Override
    public boolean isQNF() {
        return true;
    }

    public static <V> P<V> geoIntersect(V value) {
        return new P((BiPredicate)INTERSECT, value);
    }

    public static <V> P<V> geoDisjoint(V value) {
        return new P((BiPredicate)DISJOINT, value);
    }

    public static <V> P<V> geoWithin(V value) {
        return new P((BiPredicate)WITHIN, value);
    }
}

