/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.attribute;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONUtil;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.idhandling.VariableLong;

public class Geoshape {
    private static String FIELD_TYPE = "type";
    private static String FIELD_COORDINATES = "coordinates";
    private static String FIELD_RADIUS = "radius";
    private static final SpatialContext CTX = SpatialContext.GEO;
    private final float[][] coordinates;

    private Geoshape() {
        this.coordinates = null;
    }

    private Geoshape(float[][] coordinates) {
        Preconditions.checkArgument((coordinates != null && coordinates.length == 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((coordinates[0].length == coordinates[1].length && coordinates[0].length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < coordinates[0].length; ++i) {
            if (Float.isNaN(coordinates[0][i])) {
                Preconditions.checkArgument((i == 1 && coordinates.length == 2 && coordinates[1][i] > 0.0f ? 1 : 0) != 0);
                continue;
            }
            Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(coordinates[0][i], coordinates[1][i]));
        }
        this.coordinates = coordinates;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.coordinates[0]).append(this.coordinates[1]).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        Geoshape oth = (Geoshape)other;
        Preconditions.checkArgument((this.coordinates.length == 2 && oth.coordinates.length == 2 ? 1 : 0) != 0);
        for (int i = 0; i < this.coordinates.length; ++i) {
            if (this.coordinates[i].length != oth.coordinates[i].length) {
                return false;
            }
            for (int j = 0; j < this.coordinates[i].length; ++j) {
                if (Float.isNaN(this.coordinates[i][j]) && Float.isNaN(oth.coordinates[i][j]) || this.coordinates[i][j] == oth.coordinates[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        Type type = this.getType();
        StringBuilder s = new StringBuilder();
        s.append(type.toString().toLowerCase());
        switch (type) {
            case POINT: {
                s.append(this.getPoint().toString());
                break;
            }
            case CIRCLE: {
                s.append(this.getPoint().toString()).append(":").append(this.getRadius());
                break;
            }
            default: {
                s.append("[");
                for (int i = 0; i < this.size(); ++i) {
                    if (i > 0) {
                        s.append(",");
                    }
                    s.append(this.getPoint(i));
                }
                s.append("]");
            }
        }
        return s.toString();
    }

    public Type getType() {
        if (this.coordinates[0].length == 1) {
            return Type.POINT;
        }
        if (this.coordinates[0].length > 2) {
            return Type.POLYGON;
        }
        if (Float.isNaN(this.coordinates[0][1])) {
            return Type.CIRCLE;
        }
        return Type.BOX;
    }

    public int size() {
        switch (this.getType()) {
            case POINT: {
                return 1;
            }
            case CIRCLE: {
                return 1;
            }
            case BOX: {
                return 2;
            }
            case POLYGON: {
                return this.coordinates[0].length;
            }
        }
        throw new IllegalStateException("Unrecognized type: " + (Object)((Object)this.getType()));
    }

    public Point getPoint(int position) {
        if (position < 0 || position >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Invalid position: " + position);
        }
        return new Point(this.coordinates[0][position], this.coordinates[1][position]);
    }

    public Point getPoint() {
        Preconditions.checkArgument((this.size() == 1 ? 1 : 0) != 0, (Object)"Shape does not have a single point");
        return this.getPoint(0);
    }

    public float getRadius() {
        Preconditions.checkArgument((this.getType() == Type.CIRCLE ? 1 : 0) != 0, (Object)"This shape is not a circle");
        return this.coordinates[1][1];
    }

    private SpatialRelation getSpatialRelation(Geoshape other) {
        Preconditions.checkNotNull((Object)other);
        return this.convert2Spatial4j().relate(other.convert2Spatial4j());
    }

    public boolean intersect(Geoshape other) {
        SpatialRelation r = this.getSpatialRelation(other);
        return r == SpatialRelation.INTERSECTS || r == SpatialRelation.CONTAINS || r == SpatialRelation.WITHIN;
    }

    public boolean within(Geoshape outer) {
        return this.getSpatialRelation(outer) == SpatialRelation.WITHIN;
    }

    public boolean disjoint(Geoshape other) {
        return this.getSpatialRelation(other) == SpatialRelation.DISJOINT;
    }

    public Shape convert2Spatial4j() {
        switch (this.getType()) {
            case POINT: {
                return this.getPoint().getSpatial4jPoint();
            }
            case CIRCLE: {
                return CTX.makeCircle(this.getPoint(0).getSpatial4jPoint(), DistanceUtils.dist2Degrees((double)this.getRadius(), (double)6371.0087714));
            }
            case BOX: {
                return CTX.makeRectangle(this.getPoint(0).getSpatial4jPoint(), this.getPoint(1).getSpatial4jPoint());
            }
            case POLYGON: {
                throw new UnsupportedOperationException("Not yet supported");
            }
        }
        throw new IllegalStateException("Unrecognized type: " + (Object)((Object)this.getType()));
    }

    public static final Geoshape point(float latitude, float longitude) {
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(latitude, longitude), (Object)"Invalid coordinate provided");
        return new Geoshape(new float[][]{{latitude}, {longitude}});
    }

    public static final Geoshape point(double latitude, double longitude) {
        return Geoshape.point((float)latitude, (float)longitude);
    }

    public static final Geoshape circle(float latitude, float longitude, float radiusInKM) {
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(latitude, longitude), (Object)"Invalid coordinate provided");
        Preconditions.checkArgument((radiusInKM > 0.0f ? 1 : 0) != 0, (String)"Invalid radius provided [%s]", (Object[])new Object[]{Float.valueOf(radiusInKM)});
        return new Geoshape(new float[][]{{latitude, Float.NaN}, {longitude, radiusInKM}});
    }

    public static final Geoshape circle(double latitude, double longitude, double radiusInKM) {
        return Geoshape.circle((float)latitude, (float)longitude, (float)radiusInKM);
    }

    public static final Geoshape box(float southWestLatitude, float southWestLongitude, float northEastLatitude, float northEastLongitude) {
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(southWestLatitude, southWestLongitude), (Object)"Invalid south-west coordinate provided");
        Preconditions.checkArgument((boolean)Geoshape.isValidCoordinate(northEastLatitude, northEastLongitude), (Object)"Invalid north-east coordinate provided");
        return new Geoshape(new float[][]{{southWestLatitude, northEastLatitude}, {southWestLongitude, northEastLongitude}});
    }

    public static final Geoshape box(double southWestLatitude, double southWestLongitude, double northEastLatitude, double northEastLongitude) {
        return Geoshape.box((float)southWestLatitude, (float)southWestLongitude, (float)northEastLatitude, (float)northEastLongitude);
    }

    public static final boolean isValidCoordinate(float latitude, float longitude) {
        return (double)latitude >= -90.0 && (double)latitude <= 90.0 && (double)longitude >= -180.0 && (double)longitude <= 180.0;
    }

    public static class GeoshapeGsonDeserializer
    extends StdDeserializer<Geoshape> {
        public GeoshapeGsonDeserializer() {
            super(Geoshape.class);
        }

        public Geoshape deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            jsonParser.nextToken();
            float[][] f = (float[][])jsonParser.readValueAs(float[][].class);
            jsonParser.nextToken();
            return new Geoshape(f);
        }
    }

    public static class GeoshapeGsonSerializer
    extends StdSerializer<Geoshape> {
        public GeoshapeGsonSerializer() {
            super(Geoshape.class);
        }

        public void serialize(Geoshape value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeFieldName(FIELD_TYPE);
            switch (value.getType()) {
                case POLYGON: {
                    throw new UnsupportedOperationException("Polygons are not supported");
                }
                case BOX: {
                    jgen.writeString(Type.BOX.toString());
                    jgen.writeFieldName(FIELD_COORDINATES);
                    jgen.writeStartArray();
                    jgen.writeStartArray();
                    jgen.writeNumber(value.coordinates[1][0]);
                    jgen.writeNumber(value.coordinates[0][0]);
                    jgen.writeEndArray();
                    jgen.writeStartArray();
                    jgen.writeNumber(value.coordinates[1][1]);
                    jgen.writeNumber(value.coordinates[0][0]);
                    jgen.writeEndArray();
                    jgen.writeStartArray();
                    jgen.writeNumber(value.coordinates[1][1]);
                    jgen.writeNumber(value.coordinates[0][1]);
                    jgen.writeEndArray();
                    jgen.writeStartArray();
                    jgen.writeNumber(value.coordinates[1][0]);
                    jgen.writeNumber(value.coordinates[0][1]);
                    jgen.writeEndArray();
                    jgen.writeEndArray();
                    break;
                }
                case CIRCLE: {
                    jgen.writeString(Type.CIRCLE.toString());
                    jgen.writeFieldName(FIELD_RADIUS);
                    jgen.writeNumber(value.getRadius());
                    jgen.writeFieldName(FIELD_COORDINATES);
                    jgen.writeStartArray();
                    jgen.writeNumber(value.coordinates[1][0]);
                    jgen.writeNumber(value.coordinates[0][0]);
                    jgen.writeEndArray();
                    break;
                }
                case POINT: {
                    jgen.writeString(Type.POINT.toString());
                    jgen.writeFieldName(FIELD_COORDINATES);
                    jgen.writeStartArray();
                    jgen.writeNumber(value.coordinates[1][0]);
                    jgen.writeNumber(value.coordinates[0][0]);
                    jgen.writeEndArray();
                }
            }
            jgen.writeEndObject();
        }

        public void serializeWithType(Geoshape geoshape, JsonGenerator jgen, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            if (typeSerializer != null) {
                jgen.writeStringField("@class", Geoshape.class.getName());
            }
            GraphSONUtil.writeWithType((String)FIELD_COORDINATES, (Object)geoshape.coordinates, (JsonGenerator)jgen, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            jgen.writeEndObject();
        }
    }

    public static class GeoShapeGryoSerializer
    extends Serializer<Geoshape> {
        public void write(Kryo kryo, Output output, Geoshape geoshape) {
            float[][] coordinates = geoshape.coordinates;
            assert (coordinates.length == 2);
            assert (coordinates[0].length == coordinates[1].length && coordinates[0].length > 0);
            int length = coordinates[0].length;
            output.writeLong((long)length);
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < length; ++j) {
                    output.writeFloat(coordinates[i][j]);
                }
            }
        }

        public Geoshape read(Kryo kryo, Input input, Class<Geoshape> aClass) {
            long l = input.readLong();
            assert (l > 0L && l < Integer.MAX_VALUE);
            int length = (int)l;
            float[][] coordinates = new float[2][];
            for (int i = 0; i < 2; ++i) {
                coordinates[i] = input.readFloats(length);
            }
            return new Geoshape(coordinates);
        }
    }

    public static class GeoshapeSerializer
    implements AttributeSerializer<Geoshape> {
        @Override
        public void verifyAttribute(Geoshape value) {
        }

        @Override
        public Geoshape convert(Object value) {
            if (value instanceof Map) {
                return this.convertGeoJson(value);
            }
            if (value instanceof Collection) {
                value = this.convertCollection((Collection)value);
            }
            if (value.getClass().isArray() && (value.getClass().getComponentType().isPrimitive() || Number.class.isAssignableFrom(value.getClass().getComponentType()))) {
                Geoshape shape = null;
                int len = Array.getLength(value);
                double[] arr = new double[len];
                for (int i = 0; i < len; ++i) {
                    arr[i] = ((Number)Array.get(value, i)).doubleValue();
                }
                if (len == 2) {
                    shape = Geoshape.point(arr[0], arr[1]);
                } else if (len == 3) {
                    shape = Geoshape.circle(arr[0], arr[1], arr[2]);
                } else if (len == 4) {
                    shape = Geoshape.box(arr[0], arr[1], arr[2], arr[3]);
                } else {
                    throw new IllegalArgumentException("Expected 2-4 coordinates to create Geoshape, but given: " + value);
                }
                return shape;
            }
            if (value instanceof String) {
                String delimiter;
                String[] components = null;
                String[] len = new String[]{",", ";"};
                int arr = len.length;
                for (int i = 0; i < arr && ((components = ((String)value).split(delimiter = len[i])).length < 2 || components.length > 4); ++i) {
                    components = null;
                }
                Preconditions.checkArgument((components != null ? 1 : 0) != 0, (String)"Could not parse coordinates from string: %s", (Object[])new Object[]{value});
                double[] coords = new double[components.length];
                try {
                    for (int i = 0; i < components.length; ++i) {
                        coords[i] = Double.parseDouble(components[i]);
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse coordinates from string: " + value, e);
                }
                return this.convert(coords);
            }
            return null;
        }

        private double[] convertCollection(Collection<Object> c) {
            List numbers = c.stream().map(o -> {
                if (!(o instanceof Number)) {
                    throw new IllegalArgumentException("Collections may only contain numbers to create a Geoshape");
                }
                return ((Number)o).doubleValue();
            }).collect(Collectors.toList());
            return Doubles.toArray(numbers);
        }

        private Geoshape convertGeoJson(Object value) {
            try {
                Map map = (Map)value;
                String type = (String)map.get("type");
                if ("Point".equals(type) || "Circle".equals(type) || "Polygon".equals(type)) {
                    return this.convertGeometry(map);
                }
                if ("Feature".equals(type)) {
                    Map geometry = (Map)map.get("geometry");
                    return this.convertGeometry(geometry);
                }
                throw new IllegalArgumentException("Only Point, Circle, Polygon or feature types are supported");
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("GeoJSON was unparsable");
            }
        }

        private Geoshape convertGeometry(Map<String, Object> geometry) {
            String type = (String)geometry.get("type");
            List coordinates = (List)geometry.get("coordinates");
            if ("Point".equals(type)) {
                double[] parsedCoordinates = this.convertCollection(coordinates);
                return Geoshape.point(parsedCoordinates[1], parsedCoordinates[0]);
            }
            if ("Circle".equals(type)) {
                Number radius = (Number)geometry.get("radius");
                if (radius == null) {
                    throw new IllegalArgumentException("GeoJSON circles require a radius");
                }
                double[] parsedCoordinates = this.convertCollection(coordinates);
                return Geoshape.circle(parsedCoordinates[1], parsedCoordinates[0], radius.doubleValue());
            }
            if ("Polygon".equals(type)) {
                if (coordinates.size() != 4) {
                    throw new IllegalArgumentException("GeoJSON polygons are only supported if they form a box");
                }
                List polygon = coordinates.stream().map(o -> this.convertCollection((Collection)o)).collect(Collectors.toList());
                double[] p0 = (double[])polygon.get(0);
                double[] p1 = (double[])polygon.get(1);
                double[] p2 = (double[])polygon.get(2);
                double[] p3 = (double[])polygon.get(3);
                if (p0[0] == p1[0] && p1[1] == p2[1] && p2[0] == p3[0] && p3[1] == p0[1] || p0[1] == p1[1] && p1[0] == p2[0] && p2[1] == p3[1] && p3[0] == p0[0]) {
                    return Geoshape.box(this.min(p0[1], p1[1], p2[1], p3[1]), this.min(p0[0], p1[0], p2[0], p3[0]), this.max(p0[1], p1[1], p2[1], p3[1]), this.max(p0[0], p1[0], p2[0], p3[0]));
                }
                throw new IllegalArgumentException("GeoJSON polygons are only supported if they form a box");
            }
            throw new IllegalArgumentException("GeoJSON support is restricted to Point, Circle or Polygon.");
        }

        private double min(double ... numbers) {
            return Arrays.stream(numbers).min().getAsDouble();
        }

        private double max(double ... numbers) {
            return Arrays.stream(numbers).max().getAsDouble();
        }

        @Override
        public Geoshape read(ScanBuffer buffer) {
            long l = VariableLong.readPositive(buffer);
            assert (l > 0L && l < Integer.MAX_VALUE);
            int length = (int)l;
            float[][] coordinates = new float[2][];
            for (int i = 0; i < 2; ++i) {
                coordinates[i] = buffer.getFloats(length);
            }
            return new Geoshape(coordinates);
        }

        @Override
        public void write(WriteBuffer buffer, Geoshape attribute) {
            float[][] coordinates = attribute.coordinates;
            assert (coordinates.length == 2);
            assert (coordinates[0].length == coordinates[1].length && coordinates[0].length > 0);
            int length = coordinates[0].length;
            VariableLong.writePositive(buffer, length);
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < length; ++j) {
                    buffer.putFloat(coordinates[i][j]);
                }
            }
        }
    }

    public static final class Point {
        private final float longitude;
        private final float latitude;

        Point(float latitude, float longitude) {
            this.longitude = longitude;
            this.latitude = latitude;
        }

        public float getLongitude() {
            return this.longitude;
        }

        public float getLatitude() {
            return this.latitude;
        }

        private com.spatial4j.core.shape.Point getSpatial4jPoint() {
            return CTX.makePoint((double)this.longitude, (double)this.latitude);
        }

        public double distance(Point other) {
            return DistanceUtils.degrees2Dist((double)CTX.getDistCalc().distance(this.getSpatial4jPoint(), other.getSpatial4jPoint()), (double)6371.0087714);
        }

        public String toString() {
            return "[" + this.latitude + "," + this.longitude + "]";
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.latitude).append(this.longitude).toHashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!this.getClass().isInstance(other)) {
                return false;
            }
            Point oth = (Point)other;
            return this.latitude == oth.latitude && this.longitude == oth.longitude;
        }
    }

    public static enum Type {
        POINT("Point"),
        BOX("Box"),
        CIRCLE("Circle"),
        POLYGON("Polygon");

        private final String gsonName;

        private Type(String gsonName) {
            this.gsonName = gsonName;
        }

        public boolean gsonEquals(String otherGson) {
            return otherGson != null && this.gsonName.equals(otherGson);
        }

        public static Type fromGson(String gsonShape) {
            return Type.valueOf(gsonShape.toUpperCase());
        }

        public String toString() {
            return this.gsonName;
        }
    }
}

