/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.janusgraph.util.encoding.StringEncoding;

public enum EntryMetaData {
    TTL,
    VISIBILITY,
    TIMESTAMP;

    public static final java.util.Map<EntryMetaData, Object> EMPTY_METADATA;
    public static final List<EntryMetaData> IDENTIFYING_METADATA;

    public Class getDataType() {
        switch (this) {
            case VISIBILITY: {
                return String.class;
            }
            case TTL: {
                return Integer.class;
            }
            case TIMESTAMP: {
                return Long.class;
            }
        }
        throw new AssertionError((Object)("Unexpected meta data: " + (Object)((Object)this)));
    }

    public boolean isValidData(Object data) {
        Preconditions.checkNotNull((Object)data);
        switch (this) {
            case VISIBILITY: {
                if (!(data instanceof String)) {
                    return false;
                }
                return StringEncoding.isAsciiString((String)data);
            }
            case TTL: {
                return data instanceof Integer && (long)((Integer)data).intValue() >= 0L;
            }
            case TIMESTAMP: {
                return data instanceof Long;
            }
        }
        throw new AssertionError((Object)("Unexpected meta data: " + (Object)((Object)this)));
    }

    public boolean isIdentifying() {
        switch (this) {
            case VISIBILITY: {
                return true;
            }
            case TTL: 
            case TIMESTAMP: {
                return false;
            }
        }
        throw new AssertionError((Object)("Unexpected meta data: " + (Object)((Object)this)));
    }

    static {
        EMPTY_METADATA = ImmutableMap.of();
        IDENTIFYING_METADATA = new ArrayList<EntryMetaData>(3){
            {
                for (EntryMetaData meta : EntryMetaData.values()) {
                    if (!meta.isIdentifying()) continue;
                    this.add(meta);
                }
            }
        };
    }

    public static class Map
    extends EnumMap<EntryMetaData, Object> {
        public Map() {
            super(EntryMetaData.class);
        }

        @Override
        public Object put(EntryMetaData key, Object value) {
            Preconditions.checkArgument((boolean)key.isValidData(value), (String)"Invalid meta data [%s] for [%s]", (Object[])new Object[]{value, key});
            return super.put(key, value);
        }
    }
}

