/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.indexing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.schema.Mapping;

public class IndexFeatures {
    private final boolean supportsDocumentTTL;
    private final Mapping defaultStringMapping;
    private final ImmutableSet<Mapping> supportedStringMappings;
    private final String wildcardField;
    private final boolean supportsNanoseconds;
    private ImmutableSet<Cardinality> supportedCardinaities;

    public IndexFeatures(boolean supportsDocumentTTL, Mapping defaultMap, ImmutableSet<Mapping> supportedMap, String wildcardField, ImmutableSet<Cardinality> supportedCardinaities, boolean supportsNanoseconds) {
        Preconditions.checkArgument((defaultMap != null || defaultMap != Mapping.DEFAULT ? 1 : 0) != 0);
        Preconditions.checkArgument((supportedMap != null && !supportedMap.isEmpty() && supportedMap.contains((Object)defaultMap) ? 1 : 0) != 0);
        this.supportsDocumentTTL = supportsDocumentTTL;
        this.defaultStringMapping = defaultMap;
        this.supportedStringMappings = supportedMap;
        this.wildcardField = wildcardField;
        this.supportedCardinaities = supportedCardinaities;
        this.supportsNanoseconds = supportsNanoseconds;
    }

    public boolean supportsDocumentTTL() {
        return this.supportsDocumentTTL;
    }

    public Mapping getDefaultStringMapping() {
        return this.defaultStringMapping;
    }

    public boolean supportsStringMapping(Mapping map) {
        return this.supportedStringMappings.contains((Object)map);
    }

    public String getWildcardField() {
        return this.wildcardField;
    }

    public boolean supportsCardinality(Cardinality cardinality) {
        return this.supportedCardinaities.contains((Object)cardinality);
    }

    public boolean supportsNanoseconds() {
        return this.supportsNanoseconds;
    }

    public static class Builder {
        private boolean supportsDocumentTTL = false;
        private Mapping defaultStringMapping = Mapping.TEXT;
        private Set<Mapping> supportedMappings = Sets.newHashSet();
        private Set<Cardinality> supportedCardinalities = Sets.newHashSet();
        private String wildcardField = "*";
        private boolean supportsNanoseconds;

        public Builder supportsDocumentTTL() {
            this.supportsDocumentTTL = true;
            return this;
        }

        public Builder setDefaultStringMapping(Mapping map) {
            this.defaultStringMapping = map;
            return this;
        }

        public Builder supportedStringMappings(Mapping ... maps) {
            this.supportedMappings.addAll(Arrays.asList(maps));
            return this;
        }

        public Builder supportsCardinality(Cardinality cardinality) {
            this.supportedCardinalities.add(cardinality);
            return this;
        }

        public Builder setWildcardField(String wildcardField) {
            this.wildcardField = wildcardField;
            return this;
        }

        public Builder supportsNanoseconds() {
            this.supportsNanoseconds = true;
            return this;
        }

        public IndexFeatures build() {
            return new IndexFeatures(this.supportsDocumentTTL, this.defaultStringMapping, (ImmutableSet<Mapping>)ImmutableSet.copyOf(this.supportedMappings), this.wildcardField, (ImmutableSet<Cardinality>)ImmutableSet.copyOf(this.supportedCardinalities), this.supportsNanoseconds);
        }
    }
}

