/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.indexing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.Mutation;
import org.janusgraph.diskstorage.indexing.IndexEntry;

public class IndexMutation
extends Mutation<IndexEntry, IndexEntry> {
    private final boolean isNew;
    private boolean isDeleted;
    public static final Function<IndexEntry, String> ENTRY2FIELD_FCT = new Function<IndexEntry, String>(){

        @Nullable
        public String apply(@Nullable IndexEntry indexEntry) {
            return indexEntry.field;
        }
    };

    public IndexMutation(List<IndexEntry> additions, List<IndexEntry> deletions, boolean isNew, boolean isDeleted) {
        super(additions, deletions);
        Preconditions.checkArgument((!isNew || !isDeleted ? 1 : 0) != 0, (Object)"Invalid status");
        this.isNew = isNew;
        this.isDeleted = isDeleted;
    }

    public IndexMutation(boolean isNew, boolean isDeleted) {
        Preconditions.checkArgument((!isNew || !isDeleted ? 1 : 0) != 0, (Object)"Invalid status");
        this.isNew = isNew;
        this.isDeleted = isDeleted;
    }

    public void merge(IndexMutation m) {
        Preconditions.checkArgument((this.isNew == m.isNew ? 1 : 0) != 0, (Object)"Incompatible new status");
        Preconditions.checkArgument((this.isDeleted == m.isDeleted ? 1 : 0) != 0, (Object)"Incompatible delete status");
        super.merge(m);
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void resetDelete() {
        this.isDeleted = false;
    }

    @Override
    public void consolidate() {
        super.consolidate(ENTRY2FIELD_FCT, ENTRY2FIELD_FCT);
    }

    @Override
    public boolean isConsolidated() {
        return super.isConsolidated(ENTRY2FIELD_FCT, ENTRY2FIELD_FCT);
    }

    public int determineTTL() {
        return this.hasDeletions() ? 0 : IndexMutation.determineTTL(this.getAdditions());
    }

    public static int determineTTL(List<IndexEntry> additions) {
        if (additions == null || additions.isEmpty()) {
            return 0;
        }
        Preconditions.checkArgument((!additions.isEmpty() ? 1 : 0) != 0);
        int ttl = -1;
        for (IndexEntry add : additions) {
            int ittl = 0;
            if (add.hasMetaData()) {
                Preconditions.checkArgument((add.getMetaData().size() == 1 && add.getMetaData().containsKey((Object)EntryMetaData.TTL) ? 1 : 0) != 0, (String)"Index only supports TTL meta data. Found: %s", (Object[])new Object[]{add.getMetaData()});
                ittl = (Integer)add.getMetaData().get((Object)EntryMetaData.TTL);
            }
            if (ttl < 0) {
                ttl = ittl;
            }
            Preconditions.checkArgument((ttl == ittl ? 1 : 0) != 0, (String)"Index only supports uniform TTL values across all index fields, but got additions: %s", (Object[])new Object[]{additions});
        }
        assert (ttl >= 0);
        return ttl;
    }
}

