/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.locking.consistentkey;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.locking.Locker;
import org.janusgraph.diskstorage.locking.PermanentLockingException;
import org.janusgraph.diskstorage.locking.consistentkey.ExpectedValueCheckingStore;
import org.janusgraph.diskstorage.util.BackendOperation;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.KeyColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpectedValueCheckingTransaction
implements StoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(ExpectedValueCheckingTransaction.class);
    private boolean isMutationStarted;
    private final StoreTransaction strongConsistentTx;
    private final StoreTransaction inconsistentTx;
    private final Duration maxReadTime;
    private final Map<ExpectedValueCheckingStore, Map<KeyColumn, StaticBuffer>> expectedValuesByStore = new HashMap<ExpectedValueCheckingStore, Map<KeyColumn, StaticBuffer>>();

    public ExpectedValueCheckingTransaction(StoreTransaction inconsistentTx, StoreTransaction strongConsistentTx, Duration maxReadTime) {
        this.inconsistentTx = inconsistentTx;
        this.strongConsistentTx = strongConsistentTx;
        this.maxReadTime = maxReadTime;
    }

    @Override
    public void rollback() throws BackendException {
        this.deleteAllLocks();
        this.inconsistentTx.rollback();
        this.strongConsistentTx.rollback();
    }

    @Override
    public void commit() throws BackendException {
        this.inconsistentTx.commit();
        this.deleteAllLocks();
        this.strongConsistentTx.commit();
    }

    public boolean isMutationStarted() {
        return this.isMutationStarted;
    }

    @Override
    public BaseTransactionConfig getConfiguration() {
        return this.inconsistentTx.getConfiguration();
    }

    public StoreTransaction getInconsistentTx() {
        return this.inconsistentTx;
    }

    public StoreTransaction getConsistentTx() {
        return this.strongConsistentTx;
    }

    void storeExpectedValue(ExpectedValueCheckingStore store, KeyColumn lockID, StaticBuffer value) {
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkNotNull((Object)lockID);
        this.lockedOn(store);
        Map<KeyColumn, StaticBuffer> m = this.expectedValuesByStore.get(store);
        assert (null != m);
        if (m.containsKey(lockID)) {
            log.debug("Multiple expected values for {}: keeping initial value {} and discarding later value {}", new Object[]{lockID, m.get(lockID), value});
        } else {
            m.put(lockID, value);
            log.debug("Store expected value for {}: {}", (Object)lockID, (Object)value);
        }
    }

    boolean prepareForMutations() throws BackendException {
        if (!this.isMutationStarted()) {
            this.checkAllLocks();
            this.checkAllExpectedValues();
            this.mutationStarted();
        }
        return !this.expectedValuesByStore.isEmpty();
    }

    void checkAllLocks() throws BackendException {
        StoreTransaction lt = this.getConsistentTx();
        for (ExpectedValueCheckingStore store : this.expectedValuesByStore.keySet()) {
            Locker locker = store.getLocker();
            if (null == locker) continue;
            locker.checkLocks(lt);
        }
    }

    void checkAllExpectedValues() throws BackendException {
        for (ExpectedValueCheckingStore store : this.expectedValuesByStore.keySet()) {
            Map<KeyColumn, StaticBuffer> m = this.expectedValuesByStore.get(store);
            for (KeyColumn kc : m.keySet()) {
                this.checkSingleExpectedValue(kc, m.get(kc), store);
            }
        }
    }

    private void mutationStarted() {
        this.isMutationStarted = true;
    }

    private void lockedOn(ExpectedValueCheckingStore store) {
        Map<KeyColumn, StaticBuffer> m = this.expectedValuesByStore.get(store);
        if (null == m) {
            m = new HashMap<KeyColumn, StaticBuffer>();
            this.expectedValuesByStore.put(store, m);
        }
    }

    private void checkSingleExpectedValue(final KeyColumn kc, final StaticBuffer ev, final ExpectedValueCheckingStore store) throws BackendException {
        BackendOperation.executeDirect(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ExpectedValueCheckingTransaction.this.checkSingleExpectedValueUnsafe(kc, ev, store);
                return true;
            }

            public String toString() {
                return "ExpectedValueChecking";
            }
        }, this.maxReadTime);
    }

    private void checkSingleExpectedValueUnsafe(final KeyColumn kc, StaticBuffer ev, ExpectedValueCheckingStore store) throws BackendException {
        Iterable actualVals;
        ImmutableList expectedVals;
        final StaticBuffer nextBuf = BufferUtil.nextBiggerBuffer(kc.getColumn());
        KeySliceQuery ksq = new KeySliceQuery(kc.getKey(), kc.getColumn(), nextBuf);
        Iterable<Entry> actualEntries = store.getBackingStore().getSlice(ksq, this.strongConsistentTx);
        if (null == actualEntries) {
            actualEntries = ImmutableList.of();
        }
        if (!Iterables.elementsEqual((Iterable)(expectedVals = null == ev ? ImmutableList.of() : ImmutableList.of((Object)ev)), (Iterable)(actualVals = Iterables.transform((Iterable)(actualEntries = Iterables.filter((Iterable)actualEntries, (Predicate)new Predicate<Entry>(){

            public boolean apply(Entry input) {
                if (!input.getColumn().equals(kc.getColumn())) {
                    log.debug("Dropping entry {} (only accepting column {})", (Object)input, (Object)kc.getColumn());
                    return false;
                }
                log.debug("Accepting entry {}", (Object)input);
                return true;
            }
        })), (Function)new Function<Entry, StaticBuffer>(){

            public StaticBuffer apply(Entry e) {
                StaticBuffer actualCol = e.getColumnAs(StaticBuffer.STATIC_FACTORY);
                assert (null != actualCol);
                assert (null != kc.getColumn());
                assert (0 >= kc.getColumn().compareTo(actualCol));
                assert (0 > actualCol.compareTo(nextBuf));
                return e.getValueAs(StaticBuffer.STATIC_FACTORY);
            }
        })))) {
            throw new PermanentLockingException("Expected value mismatch for " + kc + ": expected=" + expectedVals + " vs actual=" + actualVals + " (store=" + store.getName() + ")");
        }
    }

    private void deleteAllLocks() throws BackendException {
        for (ExpectedValueCheckingStore s : this.expectedValuesByStore.keySet()) {
            s.deleteLocks(this);
        }
    }
}

