/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import com.codahale.metrics.Timer;
import java.util.List;
import java.util.Map;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.StoreMetaData;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRange;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.MetricInstrumentedStore;
import org.janusgraph.util.stats.MetricManager;

public class MetricInstrumentedStoreManager
implements KeyColumnValueStoreManager {
    public static final String M_OPEN_DATABASE = "openDatabase";
    public static final String M_START_TX = "startTransaction";
    public static final String M_CLOSE_MANAGER = "closeManager";
    public static final String GLOBAL_PREFIX = "global";
    private final KeyColumnValueStoreManager backend;
    private final boolean mergeStoreMetrics;
    private final String mergedMetricsName;
    private final String managerMetricsName;

    public MetricInstrumentedStoreManager(KeyColumnValueStoreManager backend, String managerMetricsName, boolean mergeStoreMetrics, String mergedMetricsName) {
        this.backend = backend;
        this.mergeStoreMetrics = mergeStoreMetrics;
        this.mergedMetricsName = mergedMetricsName;
        this.managerMetricsName = managerMetricsName;
    }

    private String getMetricsStoreName(String storeName) {
        return this.mergeStoreMetrics ? this.mergedMetricsName : storeName;
    }

    @Override
    public KeyColumnValueStore openDatabase(String name, StoreMetaData.Container metaData) throws BackendException {
        MetricManager.INSTANCE.getCounter(GLOBAL_PREFIX, this.managerMetricsName, M_OPEN_DATABASE, "calls").inc();
        return new MetricInstrumentedStore(this.backend.openDatabase(name, metaData), this.getMetricsStoreName(name));
    }

    @Override
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        if (!txh.getConfiguration().hasGroupName()) {
            this.backend.mutateMany(mutations, txh);
        }
        String prefix = txh.getConfiguration().getGroupName();
        MetricManager mgr = MetricManager.INSTANCE;
        mgr.getCounter(prefix, this.managerMetricsName, "mutate", "calls").inc();
        Timer.Context tc = mgr.getTimer(prefix, this.managerMetricsName, "mutate", "time").time();
        try {
            this.backend.mutateMany(mutations, txh);
        }
        catch (BackendException e) {
            mgr.getCounter(prefix, this.managerMetricsName, "mutate", "exceptions").inc();
            throw e;
        }
        catch (RuntimeException e) {
            mgr.getCounter(prefix, this.managerMetricsName, "mutate", "exceptions").inc();
            throw e;
        }
        finally {
            tc.stop();
        }
    }

    @Override
    public StoreTransaction beginTransaction(BaseTransactionConfig config) throws BackendException {
        MetricManager.INSTANCE.getCounter(GLOBAL_PREFIX, this.managerMetricsName, M_START_TX, "calls").inc();
        return this.backend.beginTransaction(config);
    }

    @Override
    public void close() throws BackendException {
        this.backend.close();
        MetricManager.INSTANCE.getCounter(GLOBAL_PREFIX, this.managerMetricsName, M_CLOSE_MANAGER, "calls").inc();
    }

    @Override
    public void clearStorage() throws BackendException {
        this.backend.clearStorage();
    }

    @Override
    public StoreFeatures getFeatures() {
        return this.backend.getFeatures();
    }

    @Override
    public String getName() {
        return this.backend.getName();
    }

    @Override
    public List<KeyRange> getLocalKeyPartition() throws BackendException {
        return this.backend.getLocalKeyPartition();
    }
}

