/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import org.janusgraph.diskstorage.ReadBuffer;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;

public class ReadArrayBuffer
extends StaticArrayBuffer
implements ReadBuffer {
    private transient int position = 0;

    public ReadArrayBuffer(byte[] array) {
        super(array);
    }

    ReadArrayBuffer(StaticArrayBuffer buffer) {
        super(buffer);
    }

    protected ReadArrayBuffer(byte[] array, int offset, int limit) {
        super(array, offset, limit);
    }

    @Override
    void reset(int newOffset, int newLimit) {
        this.position = 0;
        super.reset(newOffset, newLimit);
    }

    private int updatePos(int update) {
        int pos = this.position;
        this.position += update;
        return pos;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean hasRemaining() {
        return this.position < this.length();
    }

    @Override
    public void movePositionTo(int newPosition) {
        assert (newPosition >= 0 && newPosition <= this.length());
        this.position = newPosition;
    }

    @Override
    public byte getByte() {
        return this.getByte(this.updatePos(1));
    }

    @Override
    public boolean getBoolean() {
        return this.getBoolean(this.updatePos(1));
    }

    @Override
    public short getShort() {
        return this.getShort(this.updatePos(2));
    }

    @Override
    public int getInt() {
        return this.getInt(this.updatePos(4));
    }

    @Override
    public long getLong() {
        return this.getLong(this.updatePos(8));
    }

    @Override
    public char getChar() {
        return this.getChar(this.updatePos(2));
    }

    @Override
    public float getFloat() {
        return this.getFloat(this.updatePos(4));
    }

    @Override
    public double getDouble() {
        return this.getDouble(this.updatePos(8));
    }

    @Override
    public byte[] getBytes(int length) {
        byte[] result = super.getBytes(this.position, length);
        this.position += length * 1;
        return result;
    }

    @Override
    public short[] getShorts(int length) {
        short[] result = super.getShorts(this.position, length);
        this.position += length * 2;
        return result;
    }

    @Override
    public int[] getInts(int length) {
        int[] result = super.getInts(this.position, length);
        this.position += length * 4;
        return result;
    }

    @Override
    public long[] getLongs(int length) {
        long[] result = super.getLongs(this.position, length);
        this.position += length * 8;
        return result;
    }

    @Override
    public char[] getChars(int length) {
        char[] result = super.getChars(this.position, length);
        this.position += length * 2;
        return result;
    }

    @Override
    public float[] getFloats(int length) {
        float[] result = super.getFloats(this.position, length);
        this.position += length * 4;
        return result;
    }

    @Override
    public double[] getDoubles(int length) {
        double[] result = super.getDoubles(this.position, length);
        this.position += length * 8;
        return result;
    }

    @Override
    public <T> T asRelative(final StaticBuffer.Factory<T> factory) {
        if (this.position == 0) {
            return this.as(factory);
        }
        return this.as(new StaticBuffer.Factory<T>(){

            @Override
            public T get(byte[] array, int offset, int limit) {
                return factory.get(array, offset + ReadArrayBuffer.this.position, limit);
            }
        });
    }

    @Override
    public ReadBuffer subrange(int length, boolean invert) {
        return super.subrange(this.position, length, invert).asReadBuffer();
    }
}

