/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.janusgraph.core.JanusGraphFactory;

public class JanusGraphConstants {
    public static final String JANUSGRAPH_PROPERTIES_FILE = "janusgraph.internal.properties";
    public static final String VERSION;
    public static final List<String> COMPATIBLE_VERSIONS;
    public static final List<String> TITAN_COMPATIBLE_VERSIONS;

    static List<String> getCompatibleVersions(Properties props, String key) {
        ImmutableList.Builder b = ImmutableList.builder();
        b.addAll((Iterable)Stream.of(props.getProperty(key, "").split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
        return b.build();
    }

    static {
        Package p = JanusGraphConstants.class.getPackage();
        Preconditions.checkNotNull((Object)p, (Object)("Unable to load package containing class " + JanusGraphConstants.class));
        String packageName = p.getName();
        Preconditions.checkNotNull((Object)packageName, (Object)("Unable to get name of package containing " + JanusGraphConstants.class));
        String resourceName = packageName.replace('.', '/') + "/" + JANUSGRAPH_PROPERTIES_FILE;
        InputStream is = JanusGraphFactory.class.getClassLoader().getResourceAsStream(resourceName);
        Preconditions.checkNotNull((Object)is, (Object)("Unable to locate classpath resource " + resourceName + " containing JanusGraph version"));
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load properties from " + resourceName, e);
        }
        VERSION = props.getProperty("janusgraph.version");
        COMPATIBLE_VERSIONS = JanusGraphConstants.getCompatibleVersions(props, "janusgraph.compatible-versions");
        TITAN_COMPATIBLE_VERSIONS = JanusGraphConstants.getCompatibleVersions(props, "titan.compatible-versions");
    }
}

