/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.management;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.concurrent.Callable;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.schema.SchemaStatus;

public abstract class AbstractIndexStatusWatcher<R, S extends AbstractIndexStatusWatcher<R, S>>
implements Callable<R> {
    protected JanusGraph g;
    protected SchemaStatus status;
    protected Duration timeout;
    protected Duration poll;

    public AbstractIndexStatusWatcher(JanusGraph g) {
        this.g = g;
        this.status = SchemaStatus.REGISTERED;
        this.timeout = Duration.ofSeconds(60L);
        this.poll = Duration.ofMillis(500L);
    }

    protected abstract S self();

    public S status(SchemaStatus status) {
        this.status = status;
        return this.self();
    }

    public S timeout(long timeout, TemporalUnit timeoutUnit) {
        this.timeout = 0L > timeout ? null : Duration.of(timeout, timeoutUnit);
        return this.self();
    }

    public S pollInterval(long poll, TemporalUnit pollUnit) {
        Preconditions.checkArgument((0L <= poll ? 1 : 0) != 0);
        this.poll = Duration.of(poll, pollUnit);
        return this.self();
    }
}

