/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.management;

import com.google.common.base.Preconditions;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.RelationTypeIndex;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.util.time.Timer;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.database.management.AbstractIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.RelationIndexStatusReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationIndexStatusWatcher
extends AbstractIndexStatusWatcher<RelationIndexStatusReport, RelationIndexStatusWatcher> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationIndexStatusWatcher.class);
    private String relationIndexName;
    private String relationTypeName;

    public RelationIndexStatusWatcher(JanusGraph g, String relationIndexName, String relationTypeName) {
        super(g);
        this.relationIndexName = relationIndexName;
        this.relationTypeName = relationTypeName;
    }

    @Override
    protected RelationIndexStatusWatcher self() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelationIndexStatusReport call() throws InterruptedException {
        Preconditions.checkNotNull((Object)this.g, (Object)"Graph instance must not be null");
        Preconditions.checkNotNull((Object)this.relationIndexName, (Object)"Index name must not be null");
        Preconditions.checkNotNull((Object)((Object)this.status), (Object)"Target status must not be null");
        Timer t = new Timer(TimestampProviders.MILLI).start();
        while (true) {
            boolean timedOut;
            SchemaStatus actualStatus = null;
            JanusGraphManagement mgmt = null;
            try {
                mgmt = this.g.openManagement();
                RelationTypeIndex idx = mgmt.getRelationIndex(mgmt.getRelationType(this.relationTypeName), this.relationIndexName);
                actualStatus = idx.getIndexStatus();
                LOGGER.info("Index {} (relation type {}) has status {}", new Object[]{this.relationIndexName, this.relationTypeName, actualStatus});
                if (this.status.equals((Object)actualStatus)) {
                    RelationIndexStatusReport relationIndexStatusReport = new RelationIndexStatusReport(true, this.relationIndexName, this.relationTypeName, actualStatus, this.status, t.elapsed());
                    return relationIndexStatusReport;
                }
            }
            finally {
                if (null != mgmt) {
                    mgmt.rollback();
                }
            }
            boolean bl = timedOut = null != this.timeout && 0 < t.elapsed().compareTo(this.timeout);
            if (timedOut) {
                LOGGER.info("Timed out ({}) while waiting for index {} (relation type {}) to reach status {}", new Object[]{this.timeout, this.relationIndexName, this.relationTypeName, this.status});
                return new RelationIndexStatusReport(false, this.relationIndexName, this.relationTypeName, actualStatus, this.status, t.elapsed());
            }
            Thread.sleep(this.poll.toMillis());
        }
    }
}

