/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.internal;

import com.google.common.primitives.Longs;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.ElementLifeCycle;
import org.janusgraph.graphdb.internal.InternalElement;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.relations.RelationIdentifier;

public abstract class AbstractElement
implements InternalElement,
Comparable<JanusGraphElement> {
    private long id;

    public AbstractElement(long id) {
        this.id = id;
    }

    public static boolean isTemporaryId(long elementId) {
        return elementId < 0L;
    }

    public int hashCode() {
        return Long.valueOf(this.getCompareId()).hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(this instanceof Vertex && other instanceof Vertex || this instanceof Edge && other instanceof Edge || this instanceof VertexProperty && other instanceof VertexProperty)) {
            return false;
        }
        if (other instanceof AbstractElement) {
            return this.getCompareId() == ((AbstractElement)other).getCompareId();
        }
        if (other instanceof JanusGraphElement) {
            return ((JanusGraphElement)other).hasId() && this.getCompareId() == ((JanusGraphElement)other).longId();
        }
        if (other instanceof Element) {
            Object otherId = ((Element)other).id();
            if (otherId instanceof RelationIdentifier) {
                return ((RelationIdentifier)otherId).getRelationId() == this.getCompareId();
            }
            return otherId.equals(this.getCompareId());
        }
        return false;
    }

    @Override
    public int compareTo(JanusGraphElement other) {
        return AbstractElement.compare(this, other);
    }

    public static int compare(JanusGraphElement e1, JanusGraphElement e2) {
        long e1id = e1 instanceof AbstractElement ? ((AbstractElement)e1).getCompareId() : e1.longId();
        long e2id = e2 instanceof AbstractElement ? ((AbstractElement)e2).getCompareId() : e2.longId();
        return Longs.compare((long)e1id, (long)e2id);
    }

    public InternalVertex clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected long getCompareId() {
        return this.longId();
    }

    @Override
    public long longId() {
        return this.id;
    }

    @Override
    public boolean hasId() {
        return !AbstractElement.isTemporaryId(this.longId());
    }

    @Override
    public void setId(long id) {
        assert (id > 0L);
        this.id = id;
    }

    @Override
    public boolean isInvisible() {
        return IDManager.VertexIDType.Invisible.is(this.id);
    }

    @Override
    public boolean isNew() {
        return ElementLifeCycle.isNew(this.it().getLifeCycle());
    }

    @Override
    public boolean isLoaded() {
        return ElementLifeCycle.isLoaded(this.it().getLifeCycle());
    }

    @Override
    public boolean isRemoved() {
        return ElementLifeCycle.isRemoved(this.it().getLifeCycle());
    }
}

