/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap.computer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.MemoryHelper;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.Host;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceEdge;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;

public class FulgoraMemory
implements Memory.Admin {
    public final Map<String, MemoryComputeKey> memoryKeys = new HashMap<String, MemoryComputeKey>();
    public Map<String, Object> previousMap;
    public Map<String, Object> currentMap;
    private final AtomicInteger iteration = new AtomicInteger(0);
    private final AtomicLong runtime = new AtomicLong(0L);
    private volatile boolean inExecute = false;

    public FulgoraMemory(VertexProgram<?> vertexProgram, Set<MapReduce> mapReducers) {
        this.currentMap = new ConcurrentHashMap<String, Object>();
        this.previousMap = new ConcurrentHashMap<String, Object>();
        if (null != vertexProgram) {
            for (MemoryComputeKey key : vertexProgram.getMemoryComputeKeys()) {
                this.memoryKeys.put(key.getKey(), key);
            }
        }
        for (MapReduce mapReduce : mapReducers) {
            this.memoryKeys.put(mapReduce.getMemoryKey(), MemoryComputeKey.of((String)mapReduce.getMemoryKey(), (BinaryOperator)Operator.assign, (boolean)false, (boolean)false));
        }
    }

    public Set<String> keys() {
        return this.previousMap.keySet().stream().filter(key -> !this.inExecute || this.memoryKeys.get(key).isBroadcast()).collect(Collectors.toSet());
    }

    public void incrIteration() {
        this.iteration.getAndIncrement();
    }

    public void setIteration(int iteration) {
        this.iteration.set(iteration);
    }

    public int getIteration() {
        return this.iteration.get();
    }

    public void setRuntime(long runTime) {
        this.runtime.set(runTime);
    }

    public long getRuntime() {
        return this.runtime.get();
    }

    protected void complete() {
        this.iteration.decrementAndGet();
        this.previousMap = this.currentMap;
        this.memoryKeys.values().stream().filter(MemoryComputeKey::isTransient).forEach(computeKey -> this.previousMap.remove(computeKey.getKey()));
    }

    protected void completeSubRound() {
        this.previousMap = new ConcurrentHashMap<String, Object>(this.currentMap);
        this.inExecute = !this.inExecute;
    }

    public boolean isInitialIteration() {
        return this.getIteration() == 0;
    }

    public <R> R get(String key) throws IllegalArgumentException {
        Object r = this.previousMap.get(key);
        if (null == r) {
            throw Memory.Exceptions.memoryDoesNotExist((String)key);
        }
        if (this.inExecute && !this.memoryKeys.get(key).isBroadcast()) {
            throw Memory.Exceptions.memoryDoesNotExist((String)key);
        }
        return (R)r;
    }

    public void add(String key, Object value) {
        this.checkKeyValue(key, value);
        if (!this.inExecute && ("incr".equals(key) || "and".equals(key) || "or".equals(key))) {
            throw Memory.Exceptions.memoryIsCurrentlyImmutable();
        }
        if (!this.inExecute) {
            throw Memory.Exceptions.memoryAddOnlyDuringVertexProgramExecute((String)key);
        }
        this.currentMap.compute(key, (k, v) -> null == v ? value : this.memoryKeys.get(key).getReducer().apply(v, value));
    }

    public void set(String key, Object value) {
        this.checkKeyValue(key, value);
        if (this.inExecute) {
            throw Memory.Exceptions.memorySetOnlyDuringVertexProgramSetUpAndTerminate((String)key);
        }
        this.currentMap.put(key, value);
    }

    public String toString() {
        return StringFactory.memoryString((Memory)this);
    }

    private void checkKeyValue(String key, Object value) {
        if (!this.memoryKeys.containsKey(key)) {
            throw GraphComputer.Exceptions.providedKeyIsNotAMemoryComputeKey((String)key);
        }
        MemoryHelper.validateValue((Object)value);
    }

    protected void attachReferenceElements(Graph graph) {
        this.currentMap.values().stream().filter(v -> v instanceof TraverserSet).forEach(v -> FulgoraMemory.attachReferenceElements((TraverserSet<Object>)((TraverserSet)v), graph));
    }

    private static void attachReferenceElements(TraverserSet<Object> toProcessTraversers, Graph graph) {
        toProcessTraversers.stream().forEach(traverser -> {
            Object value = traverser.get();
            if (value instanceof ReferenceVertex) {
                Vertex vertex = (Vertex)((ReferenceVertex)value).attach(Attachable.Method.get((Host)graph));
                traverser.set((Object)vertex);
            } else if (value instanceof ReferenceEdge) {
                Edge edge = (Edge)((ReferenceEdge)value).attach(Attachable.Method.get((Host)graph));
                traverser.set((Object)edge);
            }
        });
    }
}

