/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.QueryException;
import org.janusgraph.graphdb.query.BackendQuery;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.query.ElementQuery;
import org.janusgraph.graphdb.query.QueryExecutor;
import org.janusgraph.graphdb.query.ResultMergeSortIterator;
import org.janusgraph.graphdb.query.ResultSetIterator;
import org.janusgraph.graphdb.query.profile.QueryProfiler;

public class QueryProcessor<Q extends ElementQuery<R, B>, R extends JanusGraphElement, B extends BackendQuery<B>>
implements Iterable<R> {
    private static final int MAX_SORT_ITERATION = 1000000;
    private final Q query;
    private final QueryExecutor<Q, R, B> executor;

    public QueryProcessor(Q query, QueryExecutor<Q, R, B> executor) {
        Preconditions.checkNotNull(query);
        Preconditions.checkNotNull(executor);
        this.query = query;
        this.executor = executor;
    }

    @Override
    public Iterator<R> iterator() {
        if (this.query.isEmpty()) {
            return Iterators.emptyIterator();
        }
        return new ResultSetIterator<R>(this.getUnfoldedIterator(), this.query.hasLimit() ? this.query.getLimit() : Integer.MAX_VALUE);
    }

    private Iterator<R> getUnfoldedIterator() {
        UnmodifiableIterator iter = null;
        boolean hasDeletions = this.executor.hasDeletions(this.query);
        Iterator<R> newElements = this.executor.getNew(this.query);
        if (this.query.isSorted()) {
            for (int i = this.query.numSubQueries() - 1; i >= 0; --i) {
                BackendQueryHolder subq = this.query.getSubQuery(i);
                ResultMergeSortIterator subqiter = this.getFilterIterator(subq.isSorted() ? new LimitAdjustingIterator(subq) : new PreSortingIterator(subq), hasDeletions, !subq.isFitted());
                iter = iter == null ? subqiter : new ResultMergeSortIterator(subqiter, iter, this.query.getSortOrder(), this.query.hasDuplicateResults());
            }
            Preconditions.checkArgument((iter != null ? 1 : 0) != 0);
            if (newElements.hasNext()) {
                ArrayList allNew = Lists.newArrayList(newElements);
                Collections.sort(allNew, this.query.getSortOrder());
                iter = new ResultMergeSortIterator(allNew.iterator(), iter, this.query.getSortOrder(), this.query.hasDuplicateResults());
            }
        } else {
            final HashSet allNew = newElements.hasNext() ? Sets.newHashSet(newElements) : ImmutableSet.of();
            ArrayList<LimitAdjustingIterator> iters = new ArrayList<LimitAdjustingIterator>(this.query.numSubQueries());
            for (int i = 0; i < this.query.numSubQueries(); ++i) {
                BackendQueryHolder subq = this.query.getSubQuery(i);
                Iterator subiter = new LimitAdjustingIterator(subq);
                subiter = this.getFilterIterator(subiter, hasDeletions, !subq.isFitted());
                if (!allNew.isEmpty()) {
                    subiter = Iterators.filter((Iterator)subiter, (Predicate)new Predicate<R>(){

                        public boolean apply(@Nullable R r) {
                            return !allNew.contains(r);
                        }
                    });
                }
                iters.add((LimitAdjustingIterator)subiter);
            }
            if (iters.size() > 1) {
                iter = Iterators.concat(iters.iterator());
                if (this.query.hasDuplicateResults()) {
                    final HashSet seenResults = new HashSet();
                    iter = Iterators.filter(iter, (Predicate)new Predicate<R>(){

                        public boolean apply(@Nullable R r) {
                            if (seenResults.contains(r)) {
                                return false;
                            }
                            seenResults.add(r);
                            return true;
                        }
                    });
                }
            } else {
                iter = (Iterator)iters.get(0);
            }
            if (!allNew.isEmpty()) {
                iter = Iterators.concat(allNew.iterator(), (Iterator)iter);
            }
        }
        return iter;
    }

    private Iterator<R> getFilterIterator(Iterator<R> iter, final boolean filterDeletions, final boolean filterMatches) {
        if (filterDeletions || filterMatches) {
            return Iterators.filter(iter, (Predicate)new Predicate<R>(){

                public boolean apply(@Nullable R r) {
                    return !(filterDeletions && QueryProcessor.this.executor.isDeleted(QueryProcessor.this.query, r) || filterMatches && !QueryProcessor.this.query.matches(r));
                }
            });
        }
        return iter;
    }

    private final class LimitAdjustingIterator
    extends org.janusgraph.graphdb.query.LimitAdjustingIterator<R> {
        private B backendQuery;
        private QueryProfiler profiler;
        private final Object executionInfo;

        private LimitAdjustingIterator(BackendQueryHolder<B> backendQueryHolder) {
            super(0x7FFFFFFE, backendQueryHolder.getBackendQuery().getLimit());
            this.backendQuery = backendQueryHolder.getBackendQuery();
            this.executionInfo = backendQueryHolder.getExecutionInfo();
            this.profiler = backendQueryHolder.getProfiler();
        }

        @Override
        public Iterator<R> getNewIterator(int newLimit) {
            if (!this.backendQuery.hasLimit() || newLimit > this.backendQuery.getLimit()) {
                this.backendQuery = this.backendQuery.updateLimit(newLimit);
            }
            return QueryProcessor.this.executor.execute(QueryProcessor.this.query, this.backendQuery, this.executionInfo, this.profiler);
        }
    }

    private final class PreSortingIterator
    implements Iterator<R> {
        private final Iterator<R> iter;

        private PreSortingIterator(BackendQueryHolder<B> backendQueryHolder) {
            ArrayList all = Lists.newArrayList(QueryProcessor.this.executor.execute(QueryProcessor.this.query, backendQueryHolder.getBackendQuery().updateLimit(1000000), backendQueryHolder.getExecutionInfo(), backendQueryHolder.getProfiler()));
            if (all.size() >= 1000000) {
                throw new QueryException("Could not execute query since pre-sorting requires fetching more than 1000000 elements. Consider rewriting the query to exploit sort orders");
            }
            Collections.sort(all, QueryProcessor.this.query.getSortOrder());
            this.iter = all.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public R next() {
            return (JanusGraphElement)this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

