/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.graph;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphIndexQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.indexing.RawQuery;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.query.BaseQuery;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexQueryBuilder
extends BaseQuery
implements JanusGraphIndexQuery {
    private static final Logger log = LoggerFactory.getLogger(IndexQueryBuilder.class);
    private static final String VERTEX_PREFIX = "v.";
    private static final String EDGE_PREFIX = "e.";
    private static final String PROPERTY_PREFIX = "p.";
    private final StandardJanusGraphTx tx;
    private final IndexSerializer serializer;
    private String indexName;
    private String query;
    private final List<Parameter> parameters;
    private String prefix;
    private final String unkownKeyName;
    private int offset;

    public IndexQueryBuilder(StandardJanusGraphTx tx, IndexSerializer serializer) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)serializer);
        this.tx = tx;
        this.serializer = serializer;
        this.parameters = Lists.newArrayList();
        this.unkownKeyName = tx.getGraph().getConfiguration().getUnknownIndexKeyName();
        this.offset = 0;
    }

    public String getIndex() {
        return this.indexName;
    }

    public Parameter[] getParameters() {
        return this.parameters.toArray(new Parameter[this.parameters.size()]);
    }

    public String getQuery() {
        return this.query;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public IndexQueryBuilder setElementIdentifier(String identifier) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)identifier), (Object)"Prefix may not be a blank string");
        this.prefix = identifier;
        return this;
    }

    public String getUnknownKeyName() {
        return this.unkownKeyName;
    }

    public IndexQueryBuilder setIndex(String indexName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)indexName));
        this.indexName = indexName;
        return this;
    }

    public IndexQueryBuilder setQuery(String query) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)query));
        this.query = query;
        return this;
    }

    @Override
    public IndexQueryBuilder offset(int offset) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"Invalid offset provided: %s", (Object[])new Object[]{offset});
        this.offset = offset;
        return this;
    }

    @Override
    public IndexQueryBuilder limit(int limit) {
        super.setLimit(limit);
        return this;
    }

    @Override
    public IndexQueryBuilder addParameter(Parameter para) {
        this.parameters.add(para);
        return this;
    }

    @Override
    public IndexQueryBuilder addParameters(Iterable<Parameter> paras) {
        Iterables.addAll(this.parameters, paras);
        return this;
    }

    @Override
    public IndexQueryBuilder addParameters(Parameter ... paras) {
        for (Parameter para : paras) {
            this.addParameter(para);
        }
        return this;
    }

    private Iterable<JanusGraphIndexQuery.Result<JanusGraphElement>> execute(ElementCategory resultType) {
        Preconditions.checkNotNull((Object)this.indexName);
        Preconditions.checkNotNull((Object)this.query);
        if (this.tx.hasModifications()) {
            log.warn("Modifications in this transaction might not be accurately reflected in this index query: {}", (Object)this.query);
        }
        Iterable<RawQuery.Result> result = this.serializer.executeQuery(this, resultType, this.tx.getTxHandle(), this.tx);
        final Function<Object, ? extends JanusGraphElement> conversionFct = this.tx.getConversionFunction(resultType);
        return Iterables.filter((Iterable)Iterables.transform(result, (Function)new Function<RawQuery.Result, JanusGraphIndexQuery.Result<JanusGraphElement>>(){

            @Nullable
            public JanusGraphIndexQuery.Result<JanusGraphElement> apply(@Nullable RawQuery.Result result) {
                return new ResultImpl<JanusGraphElement>((Element)conversionFct.apply(result.getResult()), result.getScore(), null);
            }
        }), (Predicate)new Predicate<JanusGraphIndexQuery.Result<JanusGraphElement>>(){

            public boolean apply(@Nullable JanusGraphIndexQuery.Result<JanusGraphElement> r) {
                return !r.getElement().isRemoved();
            }
        });
    }

    @Override
    public Iterable<JanusGraphIndexQuery.Result<JanusGraphVertex>> vertices() {
        this.setPrefixInternal(VERTEX_PREFIX);
        return this.execute(ElementCategory.VERTEX);
    }

    @Override
    public Iterable<JanusGraphIndexQuery.Result<JanusGraphEdge>> edges() {
        this.setPrefixInternal(EDGE_PREFIX);
        return this.execute(ElementCategory.EDGE);
    }

    @Override
    public Iterable<JanusGraphIndexQuery.Result<JanusGraphVertexProperty>> properties() {
        this.setPrefixInternal(PROPERTY_PREFIX);
        return this.execute(ElementCategory.PROPERTY);
    }

    private void setPrefixInternal(String prefix) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)prefix));
        if (this.prefix == null) {
            this.prefix = prefix;
        }
    }

    private static class ResultImpl<V extends Element>
    implements JanusGraphIndexQuery.Result<V> {
        private final V element;
        private final double score;

        private ResultImpl(V element, double score) {
            this.element = element;
            this.score = score;
        }

        @Override
        public V getElement() {
            return this.element;
        }

        @Override
        public double getScore() {
            return this.score;
        }

        /* synthetic */ ResultImpl(Element x0, double x1, 1 x2) {
            this(x0, x1);
        }
    }
}

