/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.vertex;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.schema.SchemaInspector;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.tinkerpop.ElementUtils;
import org.janusgraph.graphdb.types.system.ImplicitKey;
import org.janusgraph.graphdb.types.system.SystemRelationType;

public abstract class BaseVertexCentricQueryBuilder<Q extends BaseVertexQuery<Q>>
implements BaseVertexQuery<Q> {
    private static final String[] NO_TYPES = new String[0];
    private static final List<PredicateCondition<String, JanusGraphRelation>> NO_CONSTRAINTS = ImmutableList.of();
    protected Direction dir = Direction.BOTH;
    protected String[] types = NO_TYPES;
    protected List<PredicateCondition<String, JanusGraphRelation>> constraints = NO_CONSTRAINTS;
    protected JanusGraphVertex adjacentVertex = null;
    protected OrderList orders = new OrderList();
    protected int limit = Integer.MAX_VALUE;
    private final SchemaInspector schemaInspector;

    protected BaseVertexCentricQueryBuilder(SchemaInspector schemaInspector) {
        this.schemaInspector = schemaInspector;
    }

    protected abstract Q getThis();

    protected abstract JanusGraphVertex getVertex(long var1);

    @Override
    public Q adjacent(Vertex vertex) {
        Preconditions.checkArgument((vertex != null && vertex instanceof JanusGraphVertex ? 1 : 0) != 0, (Object)"Not a valid vertex provided for adjacency constraint");
        this.adjacentVertex = (JanusGraphVertex)vertex;
        return this.getThis();
    }

    private Q addConstraint(String type, JanusGraphPredicate rel, Object value) {
        Preconditions.checkArgument((type != null && StringUtils.isNotBlank((String)type) && rel != null ? 1 : 0) != 0);
        if (type.equals(ImplicitKey.ADJACENT_ID.name())) {
            Preconditions.checkArgument((rel == Cmp.EQUAL ? 1 : 0) != 0, (String)"Only equality constraints are supported for %s", (Object[])new Object[]{type});
            long vertexId = ElementUtils.getVertexId(value);
            Preconditions.checkArgument((vertexId > 0L ? 1 : 0) != 0, (String)"Expected valid vertex id: %s", (Object[])new Object[]{value});
            return this.adjacent(this.getVertex(vertexId));
        }
        if (type.equals(ImplicitKey.ID.name())) {
            RelationIdentifier rid = ElementUtils.getEdgeId(value);
            Preconditions.checkArgument((rid != null ? 1 : 0) != 0, (String)"Expected valid relation id: %s", (Object[])new Object[]{value});
            return this.addConstraint(ImplicitKey.JANUSGRAPHID.name(), rel, rid.getRelationId());
        }
        Preconditions.checkArgument((boolean)rel.isValidCondition(value), (Object)("Invalid condition provided: " + value));
        if (this.constraints == NO_CONSTRAINTS) {
            this.constraints = new ArrayList<PredicateCondition<String, JanusGraphRelation>>(5);
        }
        this.constraints.add(new PredicateCondition(type, rel, value));
        return this.getThis();
    }

    @Override
    public Q has(String type, Object value) {
        return this.addConstraint(type, Cmp.EQUAL, value);
    }

    @Override
    public Q hasNot(String key, Object value) {
        return this.has(key, Cmp.NOT_EQUAL, value);
    }

    @Override
    public Q has(String key) {
        return this.has(key, Cmp.NOT_EQUAL, null);
    }

    @Override
    public Q hasNot(String key) {
        return this.has(key, Cmp.EQUAL, null);
    }

    @Override
    public Q has(String key, JanusGraphPredicate predicate, Object value) {
        return this.addConstraint(key, predicate, value);
    }

    @Override
    public <T extends Comparable<?>> Q interval(String key, T start, T end) {
        this.addConstraint(key, Cmp.GREATER_THAN_EQUAL, start);
        return this.addConstraint(key, Cmp.LESS_THAN, end);
    }

    @Override
    public Q types(RelationType ... types) {
        String[] ts = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            ts[i] = types[i].name();
        }
        return this.types(ts);
    }

    @Override
    public Q labels(String ... labels) {
        return this.types(labels);
    }

    @Override
    public Q keys(String ... keys) {
        return this.types(keys);
    }

    public Q type(RelationType type) {
        return this.types(type.name());
    }

    @Override
    public Q types(String ... types) {
        if (types == null) {
            types = NO_TYPES;
        }
        for (String type : types) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)type), (String)"Invalid type: %s", (Object[])new Object[]{type});
        }
        this.types = types;
        return this.getThis();
    }

    @Override
    public Q direction(Direction d) {
        Preconditions.checkNotNull((Object)d);
        this.dir = d;
        return this.getThis();
    }

    @Override
    public Q limit(int limit) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0);
        this.limit = limit;
        return this.getThis();
    }

    @Override
    public Q orderBy(String keyName, org.apache.tinkerpop.gremlin.process.traversal.Order order) {
        Preconditions.checkArgument((boolean)this.schemaInspector.containsPropertyKey(keyName), (String)"Provided key does not exist: %s", (Object[])new Object[]{keyName});
        PropertyKey key = this.schemaInspector.getPropertyKey(keyName);
        Preconditions.checkArgument((key != null && order != null ? 1 : 0) != 0, (Object)"Need to specify and key and an order");
        Preconditions.checkArgument((boolean)Comparable.class.isAssignableFrom(key.dataType()), (String)"Can only order on keys with comparable data type. [%s] has datatype [%s]", (Object[])new Object[]{key.name(), key.dataType()});
        Preconditions.checkArgument((key.cardinality() == Cardinality.SINGLE ? 1 : 0) != 0, (String)"Ordering is undefined on multi-valued key [%s]", (Object[])new Object[]{key.name()});
        Preconditions.checkArgument((!(key instanceof SystemRelationType) ? 1 : 0) != 0, (String)"Cannot use system types in ordering: %s", (Object[])new Object[]{key});
        Preconditions.checkArgument((!this.orders.containsKey(key) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.orders.isEmpty(), (Object)"Only a single sort order is supported on vertex queries");
        this.orders.add(key, Order.convert(order));
        return this.getThis();
    }

    protected final boolean hasTypes() {
        return this.types.length > 0;
    }

    protected final boolean hasSingleType() {
        return this.types.length == 1 && this.schemaInspector.getRelationType(this.types[0]) != null;
    }

    protected final RelationType getSingleType() {
        Preconditions.checkArgument((boolean)this.hasSingleType());
        return this.schemaInspector.getRelationType(this.types[0]);
    }

    protected final boolean isImplicitKeyQuery(RelationCategory returnType) {
        if (returnType == RelationCategory.EDGE || this.types.length != 1 || !this.constraints.isEmpty()) {
            return false;
        }
        return this.schemaInspector.getRelationType(this.types[0]) instanceof ImplicitKey;
    }
}

